#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <errno.h>

int rmdir (const char *path)
{
   ULONG rc;

   rc = DosDeleteDir ((PSZ)path);

   if (rc)
   {
      if (rc == ERROR_PATH_NOT_FOUND || rc == ERROR_FILE_NOT_FOUND)
      {
         errno = ENOTDIR;
         return (-1);
      }

      if (rc == ERROR_ACCESS_DENIED)
      {
         errno = EACCES;
         return (-1);
      }

      if (rc == ERROR_INVALID_PARAMETER)
      {
         errno = EINVAL;
         return (-1);
      }

      if (rc == ERROR_FILENAME_EXCED_RANGE)
      {
         errno = ENAMETOOLONG;
         return (-1);
      }

      errno = EIO;
      return (-1);
   }

    return (0);
}

