/* SWEEP.CMD  - requires Rexx and RexxUtil*/

/* This program should apply the parameters, as a command line fed to        */
/* cmd.exe for every directory below the cuurent one.  It should apply it to */
/* the current directory as well. */

"@echo off"

/* Set the local environment */
a = setlocal()

/* Load the SysFileTree function from the Rexx util DLL */
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

/* This is the command-line we'll be applying */
Parse arg args

/* Do it in the current directory first */
args

/* Now, enumerate the subdirectories and do it to all of them */

/* Get the directory tree */
call SysFileTree '*', 'dirs', 'SDO'

/* Loop through the array, change to each directory, and execute args there */
do i=1 to dirs.0
        say dirs.i '=>' args
        "cd " dirs.i
        args
end

/* Restore the local environment */
a = endlocal()
