#ifndef __THREADTEMP_H__
#define __THREADTEMP_H__

#include <process.h>

#ifndef OS2_INCLUDED
	#define INCL_DOS
	#include <os2.h>
#endif

extern "C"{
void ThreadStarter(void *);
}

class Thread{
protected:
	APIRET Error;
	TID tid;
	ULONG StackSize;
	USHORT Started		:1;
	USHORT Suspended	:1;
	USHORT 				:(sizeof(USHORT)-2);

	void SetThreadID(TID t){tid=t;}

public:
	Thread(ULONG StackS=4096);

	TID GetThreadID(){return tid;}
	APIRET GetError(){return Error;}

	void ChangeStackSize(ULONG S){
		if(!Started) StackSize=S;
	}

	virtual void Run(void)=0;
	void Start();
	void SuspendThread();
	void KillThread();
	void ResumeThread();

friend void ThreadStarter(void *);
};






template< class C,class Arg>class ClassThreadwArg:public Thread{

	C * TheClass;
	void (C::* TheFunc)(Arg*);
	Arg *TheArg;


public:
	ClassThreadwArg(C* tc,void (C::* tf)(Arg*), Arg* ta ):
		Thread(){

		TheClass=tc;
		TheFunc=tf;
		TheArg=ta;
	}

	ClassThreadwArg():Thread(){
		TheClass=NULL;
		TheFunc=NULL;
		TheArg=NULL;
	}

	void SetInstance(C* tc){TheClass=tc;}
	void SetFunc( void (C::* tf)(Arg*) ){TheFunc=tf;}
	void SetArg(Arg* ta){TheArg=ta;}
	void Run(){
		(TheClass)->*(TheFunc))((TheArg));
	}

};


template< class C>class ClassThreadwoArg:public Thread{
	C * TheClass;
	void (C::* TheFunc)(void);

public:
	ClassThreadwoArg(C* tc,void (C::* tf)(void)):
		Thread(){

		TheClass=tc;
		TheFunc=tf;
	}

	ClassThreadwoArg(void (C::* tf)(void)):
		Thread(){

		TheFunc=tf;
	}


	ClassThreadwoArg():Thread(){
		TheClass=NULL;
		TheFunc=NULL;
	}


	void SetInstance(C* tc){TheClass=tc;}
	void SetFunc( void (C::* tf)(void) ){TheFunc=tf;}

	void Run(){
		((TheClass)->*(TheFunc))();
	}

};


template< class C>class StaticClassThreadwoArg:public Thread{

//	 void (C::* TheFunc)(void);
	void (*TheFunc)(void);

public:
	StaticClassThreadwoArg(	void (*tf)(void) ):
		Thread(){
		TheFunc=tf;
	}

	StaticClassThreadwoArg():Thread(){
		TheFunc=NULL;
	}


	void SetFunc( void (*tf)(void) ){TheFunc=tf;}

	void Run(){
		((*TheFunc))();
	}

};

#endif
