/* ========================================================================
   Submitted by:  Mark Harrison <harrison@lclark.edu>

   These two routines will allow you to save the startup position of a
   window in a private ini file.  There are two calls that will do this
   in the PM API ( WinStoreWindowPos() & WinRestoreWindowPos() ), but
   these save your data in the system ini files.  If you prefer to not
   clutter the system files up, you need to take care of saving the
   information in your own private file.

   What these two routines do is to save and restore a windows position,
   size and the previous position and size if a window is closed and
   re-opened while it is maximized or minimized.

   INI files have a three level heirarchy, set up as follows:

   Application         For example to store scores for a       Basketball
      Key Name         Basketball program, the INI file           Score
         Key Data      might look like this.                         45 51

   Although you can store more than one applications data in an INI file,
   this probably isn't a good practice in most cases.

   [ To use these functions, you need to #define the constant ID_INIPATH.
     See below for more information.  - Editor ]
======================================================================== */

VOID GetStartupData(HWND hWndFrame)
{
   HAB hab;
   CHAR szIniPath[64];
   HINI hMyHini;
   SWP Swp;
   ULONG ulSwpSize = sizeof(SWP);
   ULONG SwpOptions = SWP_ACTIVATE | SWP_MOVE | SWP_SIZE | SWP_SHOW;
   USHORT RestoreValues[6];
   ULONG ulRestoreValuesSize = sizeof(RestoreValues);

/* ========================================================================
   Load the physical pathname from the resource file.  It should be defined
   something like this.

   STRINGTABLE LOADONCALL MOVEABLE
   BEGIN
      ID_INIPATH   "C:\\APP.INI"
   END
======================================================================== */
   hab = WinQueryAnchorBlock(hWndFrame);
   WinLoadString(hab, 0, ID_INIPATH, sizeof(szIniPath), szIniPath);

   if ((hMyHini = PrfOpenProfile(hab, szIniPath))!=NULLHANDLE)
      {
      if (PrfQueryProfileData(hMyHini,
                              "App",
                              "WindowSize",
                              (PVOID)&Swp,
                              (PULONG)&ulSwpSize))
         {
         if (Swp.fl & SWP_MAXIMIZE)
            SwpOptions |= SWP_MAXIMIZE;
         else if (Swp.fl & SWP_MINIMIZE)
            SwpOptions |= SWP_MINIMIZE;

         WinSetWindowPos(hWndFrame,
                         NULLHANDLE,
                         Swp.x,
                         Swp.y,
                         Swp.cx,
                         Swp.cy,
                         SwpOptions);

/* ========================================================================
   Set the following flags in the frame window extra data.  This will tell
   the frame what size it should restore itself to if you restart minimized
   or maximized.
======================================================================== */
         if (PrfQueryProfileData(hMyHini,
                                 "App",
                                 "RestoreValues",
                                 (PVOID)&RestoreValues,
                                 (PULONG)&ulRestoreValuesSize))
            {
            WinSetWindowUShort(hWndFrame, QWS_XRESTORE, RestoreValues[0]);
            WinSetWindowUShort(hWndFrame, QWS_YRESTORE, RestoreValues[1]);
            WinSetWindowUShort(hWndFrame, QWS_CXRESTORE, RestoreValues[2]);
            WinSetWindowUShort(hWndFrame, QWS_CYRESTORE, RestoreValues[3]);
            WinSetWindowUShort(hWndFrame, QWS_XMINIMIZE, RestoreValues[4]);
            WinSetWindowUShort(hWndFrame, QWS_YMINIMIZE, RestoreValues[5]);
            }
         }
      else
         WinSetWindowPos(hWndFrame, 0, 0L, 40L, 800L, 560L, SwpOptions);
      }
   else
      WinSetWindowPos(hWndFrame, 0, 0L, 40L, 800L, 560L, SwpOptions);

   PrfCloseProfile(hMyHini);
   return;
}

VOID SaveStartupData(HWND hWndFrame)
{
   HAB hab;
   CHAR szIniPath[64];
   HINI hMyHini;
   SWP Swp;
   USHORT RestoreValues[6];

   WinQueryWindowPos(hWndFrame, &Swp);
   RestoreValues[0] = WinQueryWindowUShort(hWndFrame, QWS_XRESTORE);
   RestoreValues[1] = WinQueryWindowUShort(hWndFrame, QWS_YRESTORE);
   RestoreValues[2] = WinQueryWindowUShort(hWndFrame, QWS_CXRESTORE);
   RestoreValues[3] = WinQueryWindowUShort(hWndFrame, QWS_CYRESTORE);
   RestoreValues[4] = WinQueryWindowUShort(hWndFrame, QWS_XMINIMIZE);
   RestoreValues[5] = WinQueryWindowUShort(hWndFrame, QWS_YMINIMIZE);

   hab = WinQueryAnchorBlock(hWndFrame);
   WinLoadString(hab, 0, ID_INIPATH, sizeof(szIniPath), szIniPath);

   if ((hMyHini = PrfOpenProfile(hab, szIniPath))!=NULLHANDLE)
      {
      PrfWriteProfileData(hMyHini,
                          "App",
                          "WindowSize",
                          (PVOID)&Swp,
                          sizeof(Swp));
      PrfWriteProfileData(hMyHini,
                          "App",
                          "RestoreValues",
                          (PVOID)&RestoreValues,
                          sizeof(RestoreValues));
      }
   PrfCloseProfile(hMyHini);

   return;
}
