#define INCL_RXFUNC       /* external function values */
#define INCL_RXMACRO
#define INCL_VIO
#include <rexxsaa.h>
#include <iostream.h>
#include <string.h>



ULONG _System SysCls(UCHAR *name, ULONG numargs, RXSTRING args[],
                    PSZ *queuename, RXSTRING *retstr);


ULONG _System SysCls(UCHAR *name, ULONG numargs, RXSTRING args[],
                    PSZ *queuename, RXSTRING *retstr)
{
  BYTE bCell[2];

// If arguments, return non-zero to indicate error
  if (numargs)
    return 1;

  bCell[0] = 0x20;                     /* Space Character            */
  bCell[1] = 0x07;                     /* Default Attrib             */
  VioScrollDn( 0, 0, (USHORT)0xFFFF, (USHORT)0XFFFF,
                     (USHORT)0xFFFF, bCell, (HVIO) 0);/* CLS         */
  VioSetCurPos(0, 0, (HVIO) 0);        /*                Pos cursor  */

//return "0" to the caller
  retstr->strlength=1;
  strcpy(retstr->strptr,"0");


  return 0;
}


int main(){
  char Input[200];
  LONG      return_code;  /* interpreter return code    */
  RXSTRING  argv[2];      /* program argument string    */
  RXSTRING  retstr;       /* program return value       */
  SHORT      rc;           /* converted return code      */
  RXSTRING  INSTORE[2];
  char NumArg;

  RexxRegisterFunctionExe((PSZ)"EDM_SysCls",(PFN) &SysCls);

  INSTORE[0].strptr=NULL;
  INSTORE[0].strlength=0;
  INSTORE[1].strptr=NULL;
  INSTORE[1].strlength=0;


  cout<<"Sample EDM/2 Rexx Demonstration Program 2"<<endl<<"by Gordon Zeglinski"<<endl;
  cout<<"Type rexxsamp.cmd <ENTER> to execute supplied smaple"<<endl;
  cin>>Input;
 
  if(!strlen(Input))
     strcpy(Input,"RexxSamp.cmd");

  cout<<"Executing Sample Program "<<Input<<endl;
  cout<<"-----------------"<<endl;

  retstr.strptr=new char [1024];
  retstr.strlength=1024;

  argv[0].strptr="";
  argv[0].strlength=0;

  cout <<"Storing Macro"<<endl;

  return_code =RexxAddMacro("MACRO1", Input, RXMACRO_SEARCH_BEFORE);

  cout <<"Executing Macro"<<endl;

  return_code = RexxStart(0,             // No arguments
                        argv,            // dummy entry
                        "MACRO1",        // File name
                        INSTORE,         // NULL InStore
                        "CMD",           // use the "CMD" command processor
                        RXCOMMAND,       // execute as a command
                        NULL,            // No exit handlers
                        &rc,             // return code from REXX routine
                        &retstr);        // return string from REXX routine

  delete [] retstr.strptr;

return 0;
}
