
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#define INCL_PM
#include <os2.h>
#include "diainfo.h"
#include "pminfo.h"
#ifndef NDEBUG
//#define NDEBUG
#endif
#include "bugme.h"
#include "attr.h"
#include "view.h"

DiaInfo::DiaInfo()
{
}

static const char *title = NULL;
static View *view = NULL;
short insertion_style;

char *final_string = NULL;

static MRESULT goto_dialog(HWND w, int msg, MPARAM mp1, MPARAM mp2)
{
    switch(msg) {
    case WM_INITDLG:
	BUGME(("goto_dialog: WM_INITDLG"));
	if (view == NULL) break;
	int i;
	for (i = 0; i < view->length(); i++) {
	    BUGME(("goto_dialog: Inserting ``%s''", view->line(i)));
	    WinSendDlgItemMsg(w, DIALOG_GOTO_NODES, LM_INSERTITEM,
			      MPFROMSHORT(insertion_style),
			      MPFROMP(view->line(i)));
	}
	WinSendDlgItemMsg(w, DIALOG_GOTO_NODES, LM_SELECTITEM,
			  MPFROMSHORT(0),
			  MPFROMSHORT(TRUE));
	WinSetWindowText(w, (PSZ) title);
	return 0;
    case WM_CONTROL:
	if (SHORT1FROMMP(mp1) == DIALOG_GOTO_NODES 
	    && SHORT2FROMMP(mp1) == LN_ENTER) {
	    // We are done via a double-click
	    WinSendMsg(w, WM_COMMAND, MPFROMSHORT(DID_OK),
		       MPFROM2SHORT(CMDSRC_OTHER, FALSE));
	}
	break;
    case WM_COMMAND:
	BUGME(("goto_dialog: WM_COMMAND"));
	if (SHORT1FROMMP(mp1) == DID_OK) {
	    BUGME(("goto_dialog: WM_COMMAND DID_OK"));
	    // Cache the selection
	    int selection;
	    selection = (int) WinSendDlgItemMsg(w, DIALOG_GOTO_NODES, 
					  LM_QUERYSELECTION, NULL, NULL);
	    if (selection == LIT_NONE) break;
	    int len;
	    len = (int) WinSendDlgItemMsg(w, DIALOG_GOTO_NODES,
					  LM_QUERYITEMTEXTLENGTH, 
					  MPFROMSHORT(selection), NULL);
	    BUGME(("goto_dialog: length of text is %d", len));
	    char buf[len+1];
	    WinSendDlgItemMsg(w, DIALOG_GOTO_NODES, LM_QUERYITEMTEXT,
			      MPFROM2SHORT(selection, len+1), MPFROMP(buf));
	    buf[len] = '\0'; // Just in case
	    BUGME(("goto_dialog: string is ``%s''", buf));
	    if (final_string != NULL) free(final_string);
	    final_string = strdup(buf);
	}
	break;  // pass work to default
    }
    return WinDefDlgProc(w, msg, mp1, mp2);
}

static char *generic_goto(HWND owner, View *items, View *nodenames);

char *DiaInfo::goto_node(HWND owner)
{
    BUGME(("DiaInfo::goto_node(0x%X)", owner));
    title = "Node Goto";
    insertion_style = LIT_SORTASCENDING;
    return generic_goto(owner, ReferenceItem::all_items, 
			ReferenceItem::all_nodenames);
}

char *DiaInfo::goto_menu(HWND owner)
{
    BUGME(("DiaInfo::goto_menu(0x%X)", owner));
    title = "Node Menu";
    insertion_style = LIT_END;
    return generic_goto(owner, MenuItem::all_items, MenuItem::all_nodenames);
}

static char *generic_goto(HWND owner, View *items, View *nodenames)
{
    BUGME(("generic_goto(...)"));
    view = items;
    if (view == NULL) {
	BUGME(("generic_goto: NULL view!"));
	return NULL;
    }
    if (view->length() < 1) {
	BUGME(("generic_goto: empty view"));
	return NULL;
    }
    if (final_string != NULL) {
	free(final_string);
	final_string = NULL;
    }
    
    int code = WinDlgBox(HWND_DESKTOP, owner, goto_dialog, NULL, 
			 DIALOG_GOTO, NULL);
    if (code == DID_OK) {
	BUGME(("generic_goto: Dialog returned an OK"));
	BUGME(("generic_goto: Final selection was: ``%s''", final_string));
	if (final_string == NULL) return NULL;
	int i;
	for (i=0; i < items->length(); i++) {
	    if (!strcmp(items->line(i), final_string)) {
		char *temp = strdup(nodenames->line(i));
		BUGME(("generic_goto: returning ``%s''", temp));
		return temp;
	    }
	}
    }
    return NULL;
}
