/*
**	argv.c
**
**	These functions allow us to do all sorts of wild and crazy things will
**  list of command line arguments.
**
**	Everything revolves around a structure pointed to by and argPtr.
*/

#include "make.h"
#include "commands.h"
#include "job.h"
#include <errno.h>
#include <process.h>

argPtr argPtr_new(int seed_size)
{
	argPtr arg;

	if (seed_size < 128)
		seed_size = 128;
	arg = (argPtr)xmalloc(sizeof(*arg));
	arg->ptrs = (char **)xmalloc(seed_size * sizeof(char *));
	arg->ptrs[0] = NULL;
	arg->strs = (char *)xmalloc(seed_size);
	arg->ptr_size = arg->str_size = seed_size;
	arg->ptr_used = arg->str_used = 0;

	return arg;
}

/*
**	Add an single string argument to the end
*/

void argPtr_add(argPtr arg, char *argp)
{
	argPtr_insert(arg, arg->ptr_used, &argp, 1);
}

/*
**	Insert multiple string argments after argpos.
*/

void argPtr_insert(argPtr arg, int argpos, char **argv, int argc)
{
	int size, i, j;

	if (arg->ptr_used + argc > arg->ptr_size)
	{
		while (arg->ptr_used + argc > arg->ptr_size)
			arg->ptr_size *= 2;

		arg->ptrs = (char **)xrealloc(arg->ptrs, arg->ptr_size * sizeof(char *));
	}
	for (size = i = 0; i < argc; i++)
		size += strlen(argv[i]) + 1;

	if (arg->str_used + size > arg->str_size)
	{
		char *oldptr = arg->strs;

		while (arg->str_used + size > arg->str_size)
			arg->str_size *= 2;

		arg->strs = (char *)xrealloc(arg->strs, arg->str_size);
		if (oldptr != arg->strs)
			for (i = 0; i < arg->ptr_used; i++)
				arg->ptrs[i] = arg->strs + (arg->ptrs[i] - oldptr);
	}

	for (i = 0; i < argc; i++)
		if (size = strlen(argv[i]))
		{
			for (j = arg->ptr_used; j > argpos; j--)
				arg->ptrs[j] = arg->ptrs[j-1];
			arg->ptrs[argpos++]
				= strcpy(arg->strs + arg->str_used, argv[i]);
			arg->ptr_used++;
			arg->str_used += size + 1;
		}
	arg->ptrs[arg->ptr_used] = NULL;
}

/*
**	Delete multiple string argments starting at argpos
*/

void argPtr_delete(argPtr arg, int argpos, int num)
{
	int i;

	for (i = argpos; i < arg->ptr_used - num; i++)
		arg->ptrs[i] = arg->ptrs[i + num];
	arg->ptr_used -= num;
	arg->ptrs[arg->ptr_used] = NULL;
}

/*
**	Free the memory structures used by there argments.
*/

void argPtr_free(argPtr arg)
{
	xfree(arg->strs);
	xfree(arg->ptrs);
	xfree(arg);
}

/* End of File */
