#define INCL_DOSPROCESS
#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>

static int my_strcmp(const char *s1, const char *s2)
{
    while (*s1 != '\0') if (toupper(*s1++) != toupper(*s2++)) return 0;
    return *s2 == '\0';
}

int system(const char *command)
{
    const char *fmt = "%s \"%s\"";
    char *exec;
    char *comspec = getenv("COMSPEC");
    const char *cmd_exe = "cmd.exe";
    int is_cmd_exe;
    int i;
    RESULTCODES result;
    int rc;
    char *p;

    if (command == 0) return comspec != 0;
    if (comspec == 0) return -1;

    exec = malloc(strlen(comspec)+strlen(fmt)+strlen(command));
    if (exec == 0) return -127;

    i = strlen(comspec) - strlen(cmd_exe);
    is_cmd_exe = (i < 0) ? -1 : my_strcmp(comspec+i, cmd_exe);

    p = exec;
    strcpy(p, comspec);
    p += strlen(p)+1;
    sprintf(p, fmt, (is_cmd_exe) ? "/c" : "-c", command);
    p += strlen(p)+1;
    *p = '\0';

    rc = DosExecPgm((PCHAR)0, 0, EXEC_SYNC, (PSZ) exec, 0, &result, 
		    (PSZ) comspec);
    if (rc != 0) return -1;
    if (result.codeTerminate != TC_EXIT) return -1;
    return result.codeResult;
}
