/* frills for C++ */

typedef void (*vfp)(void);

extern vfp __new_handler;

void *
__builtin_new (sz)
     long sz;
{
  void *p;

  p = (void *) malloc (sz);
  if (p == 0)
    (*__new_handler) ();
  return p;
}

static void default_new_handler ();

vfp __new_handler = default_new_handler;

void *
__builtin_vec_new (p, maxindex, size, ctor)
     void *p;
     int maxindex, size;
     void (*ctor)(void *);
{
  int i, nelts = maxindex + 1;
  void *rval;

  if (p == 0)
    p = (void *)__builtin_new (nelts * size);

  rval = p;

  for (i = 0; i < nelts; i++)
    {
      (*ctor) (p);
      p += size;
    }

  return rval;
}

vfp
__set_new_handler (handler)
     vfp handler;
{
  vfp prev_handler;

  prev_handler = __new_handler;
  if (handler == 0) handler = default_new_handler;
  __new_handler = handler;
  return prev_handler;
}

vfp
set_new_handler (handler)
     vfp handler;
{
  return __set_new_handler (handler);
}

static void
default_new_handler ()
{
  /* don't use fprintf (stderr, ...) because it may need to call malloc.  */
  /* This should really print the name of the program, but that is hard to
     do.  We need a standard, clean way to get at the name.  */
  write (2, "Virtual memory exceeded in `new'\n", 33);
  /* don't call exit () because that may call global destructors which
     may cause a loop.  */
  _exit (-1);
}

void
__builtin_delete (ptr)
     void *ptr;
{
  if (ptr)
    free (ptr);
}

void
__builtin_vec_delete (ptr, maxindex, size, dtor, auto_delete_vec, auto_delete)
     void *ptr;
     int maxindex, size;
     void (*dtor)();
     int auto_delete;
{
  int i, nelts = maxindex + 1;
  void *p = ptr;

  ptr += nelts * size;

  for (i = 0; i < nelts; i++)
    {
      ptr -= size;
      (*dtor) (ptr, auto_delete);
    }

  if (auto_delete_vec)
    __builtin_delete (p);
}

