#define INCL_DOSDATETIME
#define INCL_DOSPROCESS
#include <os2.h>
#include <signal.h>
#include <unistd.h>

static int alarm_active = 0;
static int kill_alarm = 0;
static unsigned int seconds_remaining = 0;

static void
alarmthread()
{
   while (seconds_remaining) {
      if (kill_alarm)
         DosExit (0, 0);
      DosSleep (1000);
      --seconds_remaining;
   }

   if (kill_alarm)
      DosExit (0, 0);

   alarm_active = 0;
   kill_alarm = 0;
   raise (SIGALRM);
   DosExit (0, 0);
}


unsigned int
alarm (unsigned int seconds)
{
   TID tid;
   unsigned int result;

   if (seconds == 0 && alarm_active) {
      kill_alarm = 1;
      return (seconds_remaining);
   }

   if (alarm_active) {
      result = seconds_remaining;
      seconds_remaining = seconds;
      return (result);
   }

   kill_alarm = 0;
   alarm_active = 1;
   seconds_remaining = seconds;
   DosCreateThread (&tid, alarmthread, 0, 0, 1000);
   return (0);
}

