#define INCL_DOSMISC
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#include <os2.h>
#include <errno.h>
#include <process.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

extern int __vfork_active;
extern int __vfork_result;
extern int __vfork_tid;

int execvpe (char *path, char *argv[], char *envp[])
{
   int i;
   ULONG rc;
   int total_arg_length;
   int total_env_length;
   char *arg_strings;
   char *env_strings;
   char *ptr;
   RESULTCODES ReturnCodes;
   char ObjNameBuf[512];
   char exe_name[512];
   char base_name[512];
   PTIB ptib;
   PPIB ppib;

   if (__vfork_active) {
      DosGetInfoBlocks (&ptib, &ppib);
      if (__vfork_tid != ptib -> tib_ptib2 -> tib2_ultid) {
         errno = EPERM;
         return (-1);
      }
   } else {
      errno = EPERM;
      return (-1);
   }

   /* Try to find the .EXE file */

   strcpy (base_name, path);

   if (strchr(base_name, '\\') || strchr(base_name, ':')) {
       /* Path is provided - use it! */
       if (!access(base_name, X_OK) == -1) {
	   strcat(base_name, ".EXE");
       }
       strcpy(exe_name, base_name);
   } else {
       /* Path not provided - search the PATH environment */
       
       rc = DosSearchPath (SEARCH_ENVIRONMENT | SEARCH_CUR_DIRECTORY,
			   (PSZ) "PATH",
			   (PSZ) base_name,
			   (PBYTE) exe_name,
			   512);
       
       if (rc)
       {
	   strcat (base_name, ".EXE");
	   
	   rc = DosSearchPath (SEARCH_ENVIRONMENT | SEARCH_CUR_DIRECTORY,
			       (PSZ) "PATH",
			       (PSZ) base_name,
			       (PBYTE) exe_name,
			       512);
	   
	   if (rc)
	   {
	       if (rc == ERROR_FILE_NOT_FOUND || rc == ERROR_PATH_NOT_FOUND)
	       {
		   errno = ENOENT;
		   return (-1);
	       }
	       
	       errno = EIO;
	       return (-1);
	   }
       }
   }

   /* construct the command args for DosExecPgm */

   if (argv) {
      for (i = 0, total_arg_length = 1; argv[i]; ++i)
         total_arg_length += strlen (argv[i]) + 1;

      arg_strings = (char *)malloc (total_arg_length);

      for (i = 0, ptr = arg_strings; argv[i]; ++i)
      {
         bcopy (argv[i], ptr, strlen (argv[i])+1);
         ptr += strlen (argv[i]);
         if (i == 0)
            ptr++;
         else
            *ptr++ = ' ';
      }

      *ptr = '\0';
   } else {
      arg_strings = (char *) malloc (2);
      arg_strings[0] = '\0';
      arg_strings[1] = '\0';
   }

   if (envp) {
      for (i = 0, total_env_length = 1; envp[i]; ++i)
         total_env_length += strlen (envp[i]) + 1;

      env_strings = (char *)malloc (total_env_length);

      for (i = 0, ptr = env_strings; envp[i]; ++i)
      {
         char *tmpptr = ptr;
         bcopy (envp[i], ptr, strlen (envp[i])+1);
         while (*tmpptr != '=' && *tmpptr)
         {
            *tmpptr = toupper (*tmpptr);
            ++tmpptr;
         }
         ptr += strlen (envp[i]) + 1;
      }

      *ptr = '\0';
   } else {
      env_strings = 0;
   }

   rc = DosExecPgm (&ObjNameBuf[0],
                    512,
                    EXEC_ASYNCRESULT,
                    arg_strings,
                    env_strings,
                    &ReturnCodes,
                    exe_name);

   if (rc)
   {
      if (rc == ERROR_FILE_NOT_FOUND || rc == ERROR_PATH_NOT_FOUND)
      {
         errno = ENOENT;
         return (-1);
      }

      errno = EIO;
      return (-1);
   }

   __vfork_result = ReturnCodes.codeTerminate;
   __vfork_active = 0;
   DosExit (EXIT_THREAD, ReturnCodes.codeTerminate);
   return (-1); /* for lint */
}

