#define INCL_DOSPROCESS
#define INCL_DOSEXCEPTIONS
#include <os2.h>
#include <signal.h>
#include <errno.h>
#include <string.h>

int kill (pid_t pid, int sig)
{
   EXCEPTIONREPORTRECORD ExceptRepRec;
   PTIB tib;
   PPIB pib;

   if (sig > NSIG || sig < 1)
   {
      errno = EINVAL;
      return (-1);
   }

   DosGetInfoBlocks (&tib, &pib);

   if (pid == pib -> pib_ulpid) {
      bzero (&ExceptRepRec, sizeof (EXCEPTIONREPORTRECORD));
      ExceptRepRec.ExceptionNum = XCPT_FATAL_EXCEPTION | XCPT_CUSTOMER_CODE | sig;
      DosRaiseException (&ExceptRepRec);
   } else {
      if (sig == SIGKILL) {
         DosKillProcess (DKP_PROCESSTREE, pid);
      } else {
         errno = EPERM;
         return (-1);
      }
   }

   return (0);
}

