#include <string.h>
#include <stdlib.h>

extern char **environ;

int putenv(const char *value)
{
  const char *eq_pos = strchr(value, '=');
  int keylen;
  char **p;
  char *dup;

  if (eq_pos == 0) return -1;
  keylen = eq_pos - value;
  if (keylen == 0) return -1;
  dup = strdup(value);
  if (dup == 0) return -1;
  
  for (p=environ; *p != 0; p++)
    if (!strncmp(*p, value, keylen))
      break;

  if (*p != 0)
    {
      /* Replace old string */
      free(*p);
      *p = dup;
    }
  else
    {
      /* Insert new string */
      int cursize = p - environ;
      char **newenviron = 
	(char **) realloc(environ, sizeof(char *) * (cursize + 2));
      if (newenviron == 0) return -1;
      environ = newenviron;
      environ[cursize] = dup;
      environ[cursize+1] = 0;
    }
  return 0;
}
