#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <errno.h>

int rename (const char *from, const char *to)
{
   ULONG rc;

   rc = DosMove ((PSZ)from, (PSZ)to);

   if (rc)
   {
      if (rc == ERROR_PATH_NOT_FOUND || rc == ERROR_FILE_NOT_FOUND)
      {
         errno = ENOENT;
         return (-1);
      }

      if (rc == ERROR_ACCESS_DENIED)
      {
         errno = EACCES;
         return (-1);
      }

      if (rc == ERROR_NOT_SAME_DEVICE)
      {
         errno = EXDEV;
         return (-1);
      }

      if (rc == ERROR_INVALID_PARAMETER)
      {
         errno = EINVAL;
         return (-1);
      }

      if (rc == ERROR_FILENAME_EXCED_RANGE)
      {
         errno = ENAMETOOLONG;
         return (-1);
      }

      if (rc == ERROR_CIRCULARITY_REQUESTED)
      {
         errno = ELOOP;
         return (-1);
      }

      errno = EIO;
      return (-1);
   }

   return (0);
}

