#define INCL_DOSMEMMGR
#include <os2.h>
#include <errno.h>
#include <unistd.h>

extern char *__first_uncommited_block;
extern char *__first_uncommited_byte;

char *sbrk (int incr)
{
   ULONG rc;
   char *tmp;
   int nblocks;
   int diff;

   if (incr == 0)
      return (__first_uncommited_byte);

   tmp = __first_uncommited_byte;

   if ((__first_uncommited_byte += incr) > __first_uncommited_block) {
      diff = __first_uncommited_byte - __first_uncommited_block;
      nblocks = diff / getpagesize() + (diff % getpagesize() ? 1 : 0);
      rc = DosSetMem (__first_uncommited_block,
		      nblocks * getpagesize(),
		      PAG_COMMIT | PAG_READ | PAG_WRITE);
      if (rc) {
         errno = ENOMEM;
         return ((char *)-1);
      }
      __first_uncommited_block += nblocks * getpagesize();
   }

   return (tmp);
}

