#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <errno.h>

int unlink (char *path)
{
   ULONG rc;

   if (path == 0)
   {
      errno = EFAULT;
      return (-1);
   }

   rc = DosDelete (path);

   if (rc)
   {
      if (rc == ERROR_FILE_NOT_FOUND)
      {
         errno = ENOENT;
         return (-1);
      }

      if (rc == ERROR_PATH_NOT_FOUND)
      {
         errno = ENOTDIR;
         return (-1);
      }

      if (rc == ERROR_ACCESS_DENIED)
      {
         errno = EACCES;
         return (-1);
      }

      if (rc == ERROR_INVALID_PARAMETER)
      {
         errno = EINVAL;
         return (-1);
      }

      if (rc == ERROR_FILENAME_EXCED_RANGE)
      {
         errno = ENAMETOOLONG;
         return (-1);
      }

      errno = EIO;
      return (-1);
   }

   return (0);
}

