#define INCL_DOSMISC
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <sys/time.h>
#include <errno.h>

int utimes (const char *path, const struct timeval *times)
{
   struct tm * acctime;
   struct tm * modtime;
   FILESTATUS fs;
   ULONG rc;
   int i;
   char *newpath;

   i = strlen(path);
   if(i>1 && path[i-1] == '/' && !(i==3 && path[1]==':'))  /* need to trim */
   {
      newpath = (char *)malloc(i);
      strcpy(newpath,path);
      newpath[i-1] = 0;
      path = newpath;
   } else
      newpath = NULL;

   rc = DosQueryPathInfo ((PSZ)path, 1, (PBYTE)&fs, sizeof (FILESTATUS));
   if(newpath) free(newpath);

   if (rc)
   {
      if (rc == ERROR_PATH_NOT_FOUND || rc == ERROR_FILE_NOT_FOUND)
      {
         errno = ENOENT;
         return (-1);
      }

      if (rc == ERROR_ACCESS_DENIED)
      {
         errno = EACCES;
         return (-1);
      }

      if (rc == ERROR_INVALID_HANDLE)
      {
         errno = EBADF;
         return (-1);
      }

      errno = EIO;
      return (-1);
   }


   if (times) {
      acctime = localtime(&times[0].tv_sec);
      modtime = localtime(&times[1].tv_sec);
   } else {
      time_t tim;
      DosQuerySysInfo (QSV_TIME_LOW, QSV_TIME_LOW, (PVOID) &tim, 4);
      acctime = modtime = localtime (&tim);
   }

   fs.ftimeLastAccess.twosecs = acctime -> tm_sec;
   fs.ftimeLastAccess.minutes = acctime -> tm_min;
   fs.ftimeLastAccess.hours   = acctime -> tm_hour;
   fs.fdateLastAccess.day     = acctime -> tm_mday;
   fs.fdateLastAccess.month   = acctime -> tm_mon + 1;
   fs.fdateLastAccess.year    = acctime -> tm_year + 20;

   fs.ftimeLastWrite.twosecs = modtime -> tm_sec;
   fs.ftimeLastWrite.minutes = modtime -> tm_min;
   fs.ftimeLastWrite.hours   = modtime -> tm_hour;
   fs.fdateLastWrite.day     = modtime -> tm_mday;
   fs.fdateLastWrite.month   = modtime -> tm_mon + 1;
   fs.fdateLastWrite.year    = modtime -> tm_year + 20;

   DosSetPathInfo ((PSZ) path, FIL_STANDARD, &fs, sizeof (FILESTATUS), 0);
}


