// POV-Ray 2.0 scene file by Dan Farmer  1994.
// 
// This image uses two imagemaps that are not included here due to their
// size.  One can be created easily enough, the other can either be 
// downloaded CompuServe (see comments below) or you could change this 
// file to use a procedural texture like granite.
//
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

#declare Aluminum  = texture {
   pigment { color rgb   <0.55, 0.5, 0.45> }
   finish {
        specular 0.85
        roughness 0.01
        ambient 0.1
        diffuse 0.65
        reflection 0.45
        metallic
        brilliance 1.5
    }
}

camera {
//   omnimax
   location <-0.2, 0.6, -1.75>
   direction z*0.65
   right x* 4/3
   look_at <0, 0.2, 0>
}

// Atmospheric Stuff
background { color SkyBlue }

// A greenish fog for that underwater look
#declare Fog_Color =  color red 0.25 green 0.5 blue 0.5
fog { color Fog_Color  distance 8}

// Light source same color as fog
light_source { <-15,30,-25> color Fog_Color }


// Drive wheels
#declare Wheel =
difference {
    object { Disk_Z scale 0.23 }
    object { Disk_Z scale 0.20 translate -z*0.30 }
    pigment { 
        radial
        color_map {
            [0.00 0.10 color DarkOliveGreen color DarkOliveGreen]
            [0.10 0.40 color DarkOliveGreen color Gray10 ]
            [0.40 0.60 color Gray10 color Gray10 ]
            [0.60 0.90 color Gray10 color DarkOliveGreen ]
            [0.90 1.00 color DarkOliveGreen color DarkOliveGreen ]
        }
        frequency 120
        rotate x*90
    }
    finish { Shiny metallic }  
}

// A rectangular lug for the treads.  Use trans/rot to position around
// Consists of a box at 9 o'clock that is rotated both up and down 
// around 180 degrees.  0.02 units high, 0.04 units thick, 0.5 units 
// wide.
#declare Lug1 = 
union {
    box { <-0.28, -0.02, -0.25> <-0.25, 0.02, 0.25> }
    union {
        cone { <-0.30, 0, -0.22>, 0 <-0.28, 0, -0.22>, 0.015 }
        cone { <-0.30, 0, -0.11>, 0 <-0.28, 0, -0.11>, 0.015 }
        cone { <-0.30, 0,  0.00>, 0 <-0.28, 0,  0.00>, 0.015 }
        cone { <-0.30, 0,  0.11>, 0 <-0.28, 0,  0.11>, 0.015 }
        cone { <-0.30, 0,  0.22>, 0 <-0.28, 0,  0.22>, 0.015 }
        texture { Aluminum }
    }
}
#declare Half_Wheel = 
// Round part of tread
union {
    difference {
        object { Disk_Z scale <0.25, 0.25, 0.25> }   
        object { Disk_Z scale <0.23, 0.23, 0.251> }  
        clipped_by { 
            box { <-0.30, -0.30, -0.251> <0, 0.30, 0.251> }  // clip right half
        }
    }
    object { Lug1 rotate -z * 80.0}
    object { Lug1 rotate -z * 60.0}
    object { Lug1 rotate -z * 40.0}
    object { Lug1 rotate -z * 20.0}
    object { Lug1 rotate  z * 00.0}
    object { Lug1 rotate  z * 20.0}
    object { Lug1 rotate  z * 40.0}
    object { Lug1 rotate  z * 60.0}
    object { Lug1 rotate  z * 80.0}
}

// This lug is used for the flat portions of the tread.  Same 
// dimensions as the previous ones, but these face upward
// and are merely translated across the length of the tread.
#declare Lug2 = 
union {
    box { <-0.02, 0.0, -0.25> <0.02, 0.05, 0.25> }
    union {
        cone { <0.0, 0.05, -0.22 >, .0150 <0, 0.07, -0.22>, 0 }
        cone { <0.0, 0.05, -0.11 >, .0150 <0, 0.07, -0.11>, 0 }
        cone { <0.0, 0.05,  0.00 >, .0150 <0, 0.07,  0.00>, 0 }
        cone { <0.0, 0.05,  0.11 >, .0150 <0, 0.07,  0.11>, 0 }
        cone { <0.0, 0.05,  0.22 >, .0150 <0, 0.07,  0.22>, 0 }
        texture { Aluminum }
    }
}

#declare Tread_Flat = 
union {    
    box { <-0.9,  0.00, -0.25> <0.9, 0.02, 0.25> }
    object { Lug2 translate -x*0.8 }
    object { Lug2 translate -x*0.6 }
    object { Lug2 translate -x*0.4 }
    object { Lug2 translate -x*0.2 }
    object { Lug2 translate  x*0.0 }
    object { Lug2 translate  x*0.2 }
    object { Lug2 translate  x*0.4 }
    object { Lug2 translate  x*0.6 }
    object { Lug2 translate  x*0.8 }
}

#declare Tread =
union {
    object { Half_Wheel              translate -x*0.9 }
    object { Half_Wheel rotate y*180 translate  x*0.9 }
    object { Tread_Flat              translate  y*0.23 }
    object { Tread_Flat rotate x*180 translate -y*0.23 }

    pigment { Gray35 }
    normal { wrinkles 1.15 scale 0.015 }

    scale 1.002   // avoid coincident surfaces w/wheels
}

#declare Axel =
union {
    object { Disk_Z scale <0.035, 0.035, 0.975> }
    sphere { <0, 0, 0>, 0.075 }
    pigment { Gray70 }
    finish { Shiny metallic }  
}

#declare Hub =
union {
    object { Disk_Z scale <0.05, 0.05, 0.20> }
    object { Disk_Z scale <0.10, 0.10, 0.15> }
    pigment { DarkGreen }
    finish { Shiny metallic }  
}

#declare Wheel_Assembly =
union {
    object { Hub  translate -x*0.9 }
    object { Wheel translate -x*0.9 }
    object { Hub                   }
    object { Wheel                  }
    object { Wheel translate  x*0.9 }
    object { Hub  translate  x*0.9 }
}

#declare Single_Tread_Unit = 
union {
    object { Wheel_Assembly }
    object { Tread }
}

#declare Full_Tread_Unit = 
union {
    object { Single_Tread_Unit translate -z*0.75 }
    object { Axel  translate -x*0.9 }
    object { Axel                   }
    object { Axel  translate  x*0.9 }
    object { Single_Tread_Unit translate  z*0.75 }
}

// Overbright spotlight color is used for both the actual
// spotlight, and for the cone color.
#declare Spotlight_Color = color red 1.5 green 1.5 blue 1.25

// This is an spotlight "covered" with a faded gradient cone that
// depicts the beam as it passes through the fog.  The overbright
// color will tend to wash out some colors, but with a very realistic
// effect.
#declare Spotlight_Cone =
light_source { <0,0,0> color Spotlight_Color
    spotlight
    point_at <1, -0.1, 0> 
    radius  30
    falloff 45

    looks_like {
        union {
            union {  // The stalk-like unit that the light sits on
                sphere { <0,0,0>, 0.025 scale <1.5, 0.75, 1>}  
                cylinder { <0.0, 0, 0>, <-0.1, -0.5, 0>, 0.01 }
                texture { Aluminum } 
            }
            // The spotlight cone 
            cone { <0,0,0>, 0.01 <3, 0, 0> 0.5
                pigment { 
                    gradient x
                    color_map {
                    [0.00 color Spotlight_Color  filter 0.80 ]
                    [0.25 color Spotlight_Color  filter 0.95 ]
                    [0.50 color White            filter 1.00 ]
                    }
                scale 3
                }
                finish { Luminous }
            }
        }
        no_shadow
    }
}

#declare Body =
intersection {
    sphere { <0, 0, 0> 1 } 
    cylinder { <-1, 0, 0> <1, 0, 0>, 0.40 inverse }

    scale <1.2, 0.25, 0.5>  
    translate y*0.15
    texture { 
        Aluminum 
/*
        normal {
            // panels.gif is simply a random assortment of rectangles
            // and blotches done with a paint program.  Easy to 
            // duplicate. 640x480 resolution.   
            bump_map { gif "panels.gif" 
                bump_size -8
                interpolate 4 
                map_type Cylinder_Map
            }
            rotate z*90
        }
*/

    }
}

#declare Ocean =
// The water surface
plane { y, 3
    pigment { red 0.65 green 0.85 blue 1.0 filter 0.95 }
    finish { refraction 1.0 ior 1.1 reflection 0.7 }
    normal { 
        bumps 0.5
        scale 0.1
    }
    translate <5, 0, -10>
}
#declare Ocean_Floor =
plane { y, -0.3
    finish { ambient 0.05 diffuse 0.5 }
/*
    pigment { 
        // lava1b.gif is a tiled map of gravel found on CompuServe's
        // GRAPHDEV forum.
        image_map { gif "d:\images\maps\lava1b.gif" } 
        rotate x*90
        rotate y*33
        scale 0.3
    } 
*/
}

#declare Environment = union {
    object { Ocean }
    object { Ocean_Floor rotate y*50}
}

#declare Tank =
union {
    object { Full_Tread_Unit  }
    object { Spotlight_Cone rotate -z*05 rotate  y*65 translate <0.75, 0.5, -0.30>}
    object { Spotlight_Cone rotate -z*20 rotate -y*65 translate <0.75, 0.5,  0.30>}
    object { Body }
}
union {
    object { Environment }
    object { Tank rotate y*50 }
    object { Tank rotate y*90 translate <-2, 0, 6>}
    object { Tank rotate y*130 translate <2, 0, 9>}
}
