/*****************************************************************************/
/* module util.c							     */
/*									     */
/* Author: Markus Buchi							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

#define ETEINT 0
#define ALLUME 0177777

/*************************************************************************/
/* met le cadre de l'image a 0 */

x0_cadre(nl,nc,ima)
int nl,nc;
unsigned short **ima;
{
    register unsigned short *p_col;
    int i;
    register int j;

    ima++;
    p_col = *ima++;      /* premiere ligne */
    p_col++;             /* premiere colonne */
    *p_col++ = *p_col & ~01360;  /* point en haut a gauche */
    for(j=2;j<nc;j++)
       {
	   *p_col++ = *p_col & ~01060;
       }
    *p_col = *p_col & ~031460; /* point en haut a droite */
    for(i=2;i<nl;i++)
       {
	   p_col = *ima++;
           *(p_col+1) = *(p_col+1) & ~0340;
           *(p_col+nc) = *(p_col+nc) & ~030400;
       }
    p_col = *ima;  /* derniere ligne */
    p_col++;
    *p_col++ = *p_col & ~026340; /* point en bas a gauche */
    for(j=2;j<nc;j++)
       {
	   *p_col++ = *p_col & ~026000;
       }
    *p_col = *p_col & ~036400;  /* point en bas a droite */
}

/****************************************************************/

/* met le cadre de l'image a 1 */

x1_cadre(nl,nc,ima)
int nl,nc;
unsigned short **ima;
{
    register unsigned short *p_col;
    int i;
    register int j;

    ima++;
    p_col = *ima++;      /* premiere ligne */
    p_col++;             /* premiere colonne */
    *p_col++ = *p_col | 01360;  /* point en haut a gauche */
    for(j=2;j<nc;j++)
       {
	   *p_col++ = *p_col | 01060;
       }
    *p_col = *p_col | 031460; /* point en haut a droite */
    for(i=2;i<nl;i++)
       {
	   p_col = *ima++;
           *(p_col+1) = *(p_col+1) | 0340;
           *(p_col+nc) = *(p_col+nc) | 030400;
       }
    p_col = *ima;  /* derniere ligne */
    p_col++;
    *p_col++ = *p_col | 026340; /* point en bas a gauche */
    for(j=2;j<nc;j++)
       {
	   *p_col++ = *p_col | 026000;
       }
    *p_col = *p_col | 036400;  /* point en bas a droite */
}

/****************************************************************/

/* copie de image dans t_image */

copier(nl,nc,image,t_image)
int nl,nc;
unsigned short **image,**t_image;
{
 register unsigned short *r,*s;
       int  i;
 register int j;  

 for(i=0;i<=(nl+1);i++)
   { 
     r = *image++;
     s = *t_image++;
     for(j=0;j<=(nc+1);j++)
       {
          *s++ = *r++; 
       }
   }
}  /* end copier */

/*************************************************************************/
/* met l'image pointee par image a 0 */

ima_clear(nl,nc,image)
int nl,nc;
unsigned short **image;
{
    register unsigned short *p_col;
    int i;
    register int j;

    for(i=0;i<=(nl+1);i++)
      {
          p_col = *image;
          image++;
	  for(j=0;j<=(nc+1);j++)
            {
		*p_col++ =  ETEINT;
	    }
      }
} /* end ima_clear */


/*************************************************************************/
/* met l'image pointee par image a 1 , cadre a 0 */

ima_allum(nl,nc,image)
int nl,nc;
unsigned short **image;
{
    register unsigned short *p_col,*p_av,*p_ap;
    int i;
    register int j;
    unsigned short **ima;

    ima = image;
    image++;
    for(i=1;i<=nl;i++)
      {
          p_col = *image++;
          p_col++;
	  for(j=1;j<=nc;j++)
            {
		*p_col++ = ALLUME;
	    }
      }
    x0_cadre(nl,nc,ima);
} /* end ima_allum */

/************************************************************************/

/* retourne un pointeur sur une image vide */

unsigned char *allouer(nl, nc)
int nl, nc;
{
    long n;
    unsigned char *ima;

    n = nl*nc;
    ima = (unsigned char *) calloc(n, sizeof(*ima));
    return(ima);
} /* end allouer */

/**************************************************************************/

/* libere la place memoire de l'image pointee par ima */

desallouer(ima)
unsigned char *ima;
{
    free(ima);

} /* end desallouer */



/*************************************************************************/




/****************************************************************/
 
/* retourne un pointeur image sur l'image vide, allocation de la memoire */

unsigned short **c_allouer(nl, nc)           /* 313 */
int nl, nc;
{
    int k;
    unsigned short **image, **p_line;

    
    image = (unsigned short **) calloc(nl+2, sizeof(*p_line));
    p_line = image;
    for(k=0;k<=nl+1;k++)
      {
	  *p_line++ = (unsigned short *) calloc(nc+2, sizeof(**p_line));
      }
    return(image);
} /* end c_allouer */

/**************************************************************************/

/* libere la place memoire de l'image pointee par image */

c_desallouer(nl, image)
int nl;
unsigned short **image;
{
    int k;
    unsigned short *p_col, **p_line;

    p_line = image;
    for(k=0;k<=nl+1;k++)
      {
	  p_col = *p_line++;
          free(p_col);
      }
    free(image);
} /* end c_desallouer */


/*************************************************************************/


