/*****************************************************************************/
/* module mm.c								     */
/*									     */
/* Author: Rene Perrier							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   June 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

/* programme de Morphologie Mathematique a niveau de gris */
/* utilise par le programme "win" du labo de traitement des images */
/* RENE PERRIER  27.6.88 */
/* A.JACOT-DESCCOMBES 25.11.88 mise-a-jour de la gaussienne */

# include <stdio.h>
# include <ctype.h>
# include <string.h>


#define MAX(x,y)   (((x) < (y))  ?  (y) : (x))
#define MIN(x,y)   (((x) < (y))  ?  (x) : (y))


#define  TYPE_SHORT  1
#define  MAXSHORT 32767
#define  MINSHORT -32768
#define  MAX_IMAGE 10
#define	 TRUE 1
#define	 FALSE 0

#define IMAGE       short
#define EL_STRUCT   struct el_struct
EL_STRUCT
         {
	 short      x;
         short      y;
         short      z;
         EL_STRUCT  *next;
	 };

#define ELEMENT struct element
ELEMENT
       {
       short  type;
       short  param1;
       short  param2;
       float  param3, param4, param5;
       };

struct description_memoire {
    short   type, nligne, ncolonne;
    char    date[26];
    float   mmin, mmax, mu, ecart;
    char    filename[30];
    char    comment[384];
    };

extern struct description_memoire  dir_desc[];

struct directoire_image {
    int    flag_reserve;
    unsigned char * image;
    };

extern struct directoire_image dir_image[];
extern struct directoire_image buffer_image[];

int flag_autoconvert;

short type, nligne, ncolonne;   /* variables globales */

    /* fonctions definies dans el.c  :   */
 EL_STRUCT *sphere();
 EL_STRUCT *cone();
 EL_STRUCT *cylindre();
 EL_STRUCT *gaussienne();
 EL_STRUCT *plan_image();



/*===========================================================================*/
/*   erosion :                                                               */
/*   ~~~~~~~~~                                                               */
/*              La procedure erosion erode l'image pointee par im_dep avec   */
/*    l'element structurant pointe par b et place le resultat dans l'image   */
/*    pointee par im_arr. L'image de depart n'est pas modifiee.              */
/*                                                                           */
/*    im_arr(x,y) = MIN [ im_dep(x+i,y+j) - b(i,j) ]    avec (x+i,y+j) dans  */
/*                  i,j                                   le support(im_dep) */


 void erosion_ng(im_dep,im_arr,b)

   IMAGE      *im_dep, *im_arr;
   EL_STRUCT  *b;

   {
   int        register k;
   short      register i,j,r,s;
   short      register min;
   EL_STRUCT  *ptr;
   int        *indice, *p;

   /* construction du tableau indice tel que  indice[i] = i * ncolonne */
   k = 0;
   indice = (int *) malloc (nligne * sizeof(int));
   p = indice;
   for (i = 0; i < nligne; i++)
      {
      *p = k;
      p ++;
      k += ncolonne;
      };

   k = 0;
   for (i = 0; i < nligne; i++)           /* boucle de parcours des points de l'image */
      for (j = 0; j < ncolonne; j++)
         {
	 ptr = b;
         min = MAXSHORT;  /* valeur sentinelle */
         while (ptr != NULL)        /* parcours des vecteurs de l'element structurant */
            {
            if (((r = i + ptr->x) >= nligne) || (r < 0) ||
                  ((s = j + ptr->y) >= ncolonne) || (s < 0));
            else
               {  
                                        /* (x+i,y+j) appartient au support de l'image */
               min = im_arr[k] = MIN(min,(im_dep[indice[r] + s] - ptr->z));
	       };
            ptr = ptr->next;
	    };
         k++;
	 };
   };

/*===========================================================================*/
/*   dilatation :                                                            */
/*   ~~~~~~~~~~~~                                                            */
/*              La procedure dilatation dilate l'image pointee par im_dep    */
/*    avec l'element structurant pointe par b et place le resultat dans      */
/*    l'image pointee par im_arr. L'image de depart n'est pas modifiee.      */
/*                                                                           */
/*    im_arr(x,y) = MAX [ im_dep(x-i,y-j) + b(i,j) ]    avec (x-i,y-j) dans  */
/*                  i,j                                   le support(im_dep) */


 void dilatation_ng(im_dep,im_arr,b)

   IMAGE      *im_dep, *im_arr;
   EL_STRUCT  *b;

   {
   int   register k;
   short register i,j,r,s;
   short register max;
   EL_STRUCT *ptr;
   int        *indice, *p;

   k = 0;
   indice = (int *) malloc (nligne * sizeof(int));
   p = indice;
   for (i = 0; i < nligne; i++)
      {
      *p = k;
      p ++;
      k += ncolonne;
      };

   k = 0;
   for (i = 0; i < nligne; i++)
      for (j = 0; j < ncolonne; j++)
         {
	 ptr = b;
         max = MINSHORT;
         while (ptr != NULL)
            {
            if (((r = i - ptr->x) >= nligne) || (r < 0) ||
                  ((s = j - ptr->y) >= ncolonne) || (s < 0));
            else
               {
               max = im_arr[k] = MAX(max,(im_dep[indice[r] + s] + ptr->z));
	       };
            ptr = ptr->next;
	    };
         k++;
	 };
   };


/*===========================================================================*/
/*   ouverture  :                                                            */
/*   ~~~~~~~~~~~~                                                            */
/*              La procedure ouverture ouvre l'image pointee par im_dep      */
/*    avec l'element structurant pointe par b et place le resultat dans      */
/*    l'image pointee par im_arr. L'image de depart n'est pas modifiee.      */
/*                                                                           */
/*    ouverture = erosion, puis dilatation                                   */

void ouverture_ng(im_dep,im_arr,b)

   IMAGE      *im_dep, *im_arr;
   EL_STRUCT  *b;

   {
   IMAGE *im_temp;

   im_temp = (IMAGE *) malloc (nligne * ncolonne * 2);
   erosion_ng(im_dep,im_temp,b);
   dilatation_ng(im_temp,im_arr,b);
   free(im_temp);
   };


/*===========================================================================*/
/*   fermeture  :                                                            */
/*   ~~~~~~~~~~~~                                                            */
/*              La procedure fermeture ferme l'image pointee par im_dep      */
/*    avec l'element structurant pointe par b et place le resultat dans      */
/*    l'image pointee par im_arr. L'image de depart n'est pas modifiee.      */
/*                                                                           */
/*    fermeture = dilatation, puis erosion                                   */

void fermeture_ng(im_dep,im_arr,b)

   IMAGE      *im_dep, *im_arr;
   EL_STRUCT  *b;

   {
   IMAGE *im_temp;

   im_temp = (IMAGE *) malloc (nligne * ncolonne * 2);
   dilatation_ng(im_dep,im_temp,b);
   erosion_ng(im_temp,im_arr,b);
   free(im_temp);
   };


/*###########################################################################*/
/*   MENU  PRINCIPAL                                                         */ 

void entree_morpho_nivgris(op,im_dep,im_arr,ptr)

   int      op;      /* operation a effectuer */
   int      im_dep;  /* numero du plan image de depart */
   int      im_arr;  /* numero du plan image d'arrivee */
   ELEMENT  *ptr;    /* parametres concernant l'element structurant */

   {
   EL_STRUCT  *b;
   IMAGE      *image_arr, *image_dep;
   int	      flag_conv;
   
   nligne = dir_desc[im_dep].nligne;
   ncolonne = dir_desc[im_dep].ncolonne;

   image_arr = (IMAGE *) malloc (nligne * ncolonne * 2);

   /* construction de l'element structurant a utiliser */
   switch(ptr->type)
      {
      case 0:
             b = sphere(ptr->param1);
             break;

      case 1:
             b = cone(ptr->param1,ptr->param2);
             break;

      case 2:
             b = cylindre(ptr->param1,ptr->param2);
             break;

      case 3 :
             b = gaussienne(ptr->param3, ptr->param4, ptr->param5);
             break;

      case 10:
/*	     if (dir_desc[ptr->param1].type != 1){
		image_dep = (IMAGE *) conv_short(ptr->param1);
		flag_conv = TRUE;
	     }
	     else{
		image_dep = (IMAGE *) dir_image[ptr->param1].image;
		flag_conv = FALSE;
	     }
*/            switch (dir_desc[ptr->param1].type){
		case -1:
		case 0: flag_conv = TRUE;
			image_dep = (short *)conv_short(ptr->param1);
			break;
		case 1: flag_conv = FALSE;
			image_dep = (short *)dir_image[ptr->param1].image;
			break;
		case 2:
		case 3:
		case 4:
		case 5:flag_autoconvert = TRUE;
		       autoconvert_short(ptr->param1);
		       image_dep = (short *)buffer_image[0].image;
		       break;
	    }


              b = plan_image(image_dep,
                             dir_desc[ptr->param1].nligne,
			     dir_desc[ptr->param1].ncolonne);
	      if (flag_conv){
		  free (image_dep);
		  flag_conv = FALSE;
	      }
	      if (flag_autoconvert){
		  free (image_dep);
		  flag_autoconvert = FALSE;
	      }
              break;
      };

   /* execution de l'operation a effectuer */
/*   if (dir_desc[im_dep].type != 1){
      image_dep = (IMAGE *)conv_short(im_dep);
      flag_conv = TRUE;
   }
   else{
      image_dep = (IMAGE *)dir_image[im_dep].image;
      flag_conv = FALSE;
   } */
           switch (dir_desc[im_dep].type){
		case -1:
		case 0: flag_conv = TRUE;
			image_dep = (short *)conv_short(im_dep);
			break;
		case 1: flag_conv = FALSE;
			image_dep = (short *)dir_image[im_dep].image;
			break;
		case 2:
		case 3:
		case 4:
		case 5:flag_autoconvert = TRUE;
		       autoconvert_short(im_dep);
		       image_dep = (short *)buffer_image[0].image;
		       break;
	    }
   switch(op){
      case 10:erosion_ng (image_dep, image_arr, b);
              break;
      case 11:dilatation_ng (image_dep, image_arr, b);
              break;
      case 12:ouverture_ng (image_dep, image_arr, b);
              break;
      case 13:fermeture_ng (image_dep, image_arr, b);
              break;
      };


 /*  if (flag_conv) free (image_dep); */
	      if (flag_conv){
		  free (image_dep);
		  flag_conv = FALSE;
	      }

	      if (flag_autoconvert){
		  free (image_dep);
		  flag_autoconvert = FALSE;
	      }

   if (dir_image[im_arr].image != NULL)  free(dir_image[im_arr].image);
   dir_image[im_arr].image = (unsigned char *) image_arr;
/*
   free(image_arr);
*/
   /* mise a jour des statistiques de l'image resultante */

   dir_desc[im_arr] = dir_desc[im_dep];
/*
   dir_desc[im_arr].nligne = nligne;
   dir_desc[im_arr].ncolonne = ncolonne;
*/
   dir_desc[im_arr].type = TYPE_SHORT;

   statis (dir_image[im_arr].image,
           dir_desc[im_arr].type,
           dir_desc[im_arr].nligne,
           dir_desc[im_arr].ncolonne,
           &(dir_desc[im_arr].mmin),
           &(dir_desc[im_arr].mmax),
           &(dir_desc[im_arr].mu),
           &(dir_desc[im_arr].ecart));

   return;
   };
