/* SCCS @(#)LaboImage.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                            LaboImage.callback.c                      */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   LaboImage.callback.c                                */
/*                                                                      */
/* DESCRIPTION  :   Interface for LaboImage                             */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "LaboImage.layout.h"
#include "libwidgets/widgetstructure.h"
#include "pre_pro.layout.h"
#include "i_olim.layout.h"
#include "i_osto_pos.layout.h"
#include "dissim.layout.h"
#include "IOplans.layout.h"
#include "LaboMorphoBin.layout.h"
#include "LaboGel1D.layout.h"
#include "gel1D_in4.h"
#include "Tool/image_generation.layout.h"
#include "descTOOL.layout.h"
#include "mapeditTOOL.layout.h"
#include "reg_growingTOOL.layout.h"
#include "win4.h"

/******************************************************
/   cancelCallback for Widget  Quit_Labo 
/*****************************************************/

void
Cancel_Labo(Quit_Labo, clientData, callData)
	Widget Quit_Labo;
	caddr_t clientData;
	caddr_t callData;
{
XtUnmanageChild (Quit_Labo);
}


/******************************************************
/   okCallback for Widget  Quit_Labo 
/*****************************************************/

void
OKquitLaboimage(Quit_Labo, clientData, callData)
	Widget Quit_Labo;
	caddr_t clientData;
	caddr_t callData;
{
XtCloseDisplay (XtDisplay (Quit_Labo));
exit (0);
}



/******************************************************
/   activateCallback for Widget  PushButton_6
/*****************************************************/

void
Quit_Laboimage(PushButton_6, Quit_Labo, callData)
	Widget PushButton_6;
	Widget Quit_Labo;
	caddr_t callData;
{
XtManageChild(Quit_Labo);
}



/******************************************************
/   activateCallback for Widget  RadioButton_2
/*****************************************************/

void
Help_off(RadioButton_2, Help_Labo, callData)
	Widget RadioButton_2;
	Widget Help_Labo;
	caddr_t callData;
{
  flag_help = FALSE;
  flag_help_only = FALSE;
  XtUnmanageChild(Help_Labo);
}



/******************************************************
/   activateCallback for Widget  RadioButton_3 
/*****************************************************/

void
Help_on(RadioButton_3, Help_Labo, callData)
	Widget RadioButton_3;
	Widget Help_Labo;
	caddr_t callData;
{
  Dimension X, Y, Width;
  Arg args[MAX_ARGS];
  int n;

  n = 0;
  XtSetArg(args[n],XmNx, &X); n++;
  XtSetArg(args[n],XmNy, &Y); n++;
  XtSetArg(args[n],XmNwidth, &Width); n++;
  XtGetValues(gLabowidget, args, n);

  flag_help_only = FALSE;  
  flag_help = TRUE;

  n = 0;
  XtSetArg(args[n],XmNx,X+Width); n++;
  XtSetArg(args[n],XmNy,Y); n++;
  XtSetValues(Help_Labo, args, n);
  XtManageChild(Help_Labo);
}


/******************************************************
/   activateCallback for Widget  RadioButton_4
/*****************************************************/

void
Help_only(RadioButton_4, Help_Labo, callData)
	Widget RadioButton_4;
	Widget Help_Labo;
	caddr_t callData;
{
  flag_help = FALSE;
  flag_help_only = TRUE;
  XtManageChild(Help_Labo);
}


/******************************************************
/   activateCallback for Widget  IO 
/*****************************************************/

void
IO_actcall(IO, Comment_Area, callData)
	Widget IO;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) io_help_proc();
}


/******************************************************
/   activateCallback for Widget  IO_load 
/*****************************************************/

void
IO_load_actcall(IO_load, Comment_Area, callData)
	Widget IO_load;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) mentree_help_proc();
}


/******************************************************
/   activateCallback for Widget  IO_load_image 
/*****************************************************/

void
IO_load_image_actcall(IO_load_image, Comment_Area, callData)
	Widget IO_load_image;
        Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;

if (flag_help_only){
      hproc_acquis_standard();
      return;
}
if (flag_help) hproc_acquis_standard();

IO_load_image_file_widget = 
	build_IO_load_image_file_widget(IO_load_image, 1, panel_titres[10]);
XtManageChild(IO_load_image_file_widget);
}


/******************************************************
/   activateCallback for Widget  IO_load_imageb 
/*****************************************************/

void
IO_load_bimage_actcall(IO_load_imageb, Comment_Area, callData)
	Widget IO_load_imageb;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;

if (flag_help_only){
      hproc_acquis_pseudo_std();
      return;
}
if (flag_help) hproc_acquis_pseudo_std();
	
IO_load_image_file_widget = 
	build_IO_load_image_file_widget(IO_load_imageb, 2, panel_titres[11]);
XtManageChild(IO_load_image_file_widget);
}


/******************************************************
/   activateCallback for Widget  IO_load_lts 
/*****************************************************/

void
IO_load_lts_actcall(IO_load_lts, Comment_Area, callData)
	Widget IO_load_lts;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;
	
if (flag_help_only){
      hproc_acquis_lts();
      return;
}
if (flag_help) hproc_acquis_lts();

IO_load_image_file_widget = 
	build_IO_load_image_file_widget(IO_load_lts, 3, panel_titres[12]);
XtManageChild(IO_load_image_file_widget);
}


/******************************************************
/   activateCallback for Widget  IO_load_rgb 
/*****************************************************/

void
IO_load_rgb_actcall(IO_load_rgb, Comment_Area, callData)
	Widget IO_load_rgb;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;
	
if (flag_help_only){	
      hproc_acquis_rgb();
      return;
}    
if (flag_help)  hproc_acquis_rgb();

IO_load_image_file_widget = 
	build_IO_load_image_file_widget(IO_load_rgb, 4, panel_titres[13]);
XtManageChild(IO_load_image_file_widget);
}



/******************************************************
/   activateCallback for Widget  IO_load_melanie
/*****************************************************/

void
IO_load_melanie_actcall(IO_load_melanie, Comment_Area, callData)
	Widget IO_load_melanie;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;
	
IO_load_image_file_widget = 
	build_IO_load_image_file_widget(IO_load_melanie, 6, panel_titres[14]);
XtManageChild(IO_load_image_file_widget);
}


/******************************************************
/   activateCallback for Widget  IO_load_sun 
/*****************************************************/

void
IO_load_sun_actcall(IO_load_sun, Comment_Area, callData)
	Widget IO_load_sun;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;

if (flag_help_only){
      hproc_read_rasterfile();
      return;
}
if (flag_help) hproc_read_rasterfile();

IO_load_image_file_widget = 
	build_IO_load_image_file_widget(IO_load_sun, 5, panel_titres[15]);
XtManageChild(IO_load_image_file_widget);
}


/******************************************************
/   activateCallback for Widget  IO_store 
/*****************************************************/

void
IO_store_actcall(IO_store, Comment_Area, callData)
	Widget IO_store;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) sauve_help_proc();
}


/******************************************************
/   activateCallback for Widget  IO_store_single
/*****************************************************/

void
IO_store_single_actcall(IO_store_single, Comment_Area, callData)
	Widget IO_store_single;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;
	
if (flag_help_only){
      hproc_sauve_unplan();
      return;
}
if (flag_help) hproc_sauve_unplan();

IO_load_image_file_widget = 
	build_IO_store_post_file_widget(IO_store_single, 1, panel_titres[16]);
XtManageChild(IO_load_image_file_widget);
}


/******************************************************
/   activateCallback for Widget  IO_store_cartesian
/*****************************************************/

void
IO_store_cartesian_actcall(IO_store_cartesian, Comment_Area, callData)
	Widget IO_store_cartesian;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;
	
if (flag_help_only){
      hproc_sauve_imcart();
      return;
}
if (flag_help) hproc_sauve_imcart();

IO_load_image_file_widget = 
	build_IO_store_post_file_widget(IO_store_cartesian, 2, panel_titres[17]);
XtManageChild(IO_load_image_file_widget);
}


/******************************************************
/   activateCallback for Widget  IO_store_polar
/*****************************************************/

void
IO_store_polar_actcall(IO_store_polar, Comment_Area, callData)
	Widget IO_store_polar;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;
	
if (flag_help_only){
     hproc_sauve_impol();
     return;
}
if (flag_help) hproc_sauve_impol();

IO_load_image_file_widget = 
	build_IO_store_post_file_widget(IO_store_polar, 3, panel_titres[18]);
XtManageChild(IO_load_image_file_widget);
}


/******************************************************
/   activateCallback for Widget  IO_store_rgb
/*****************************************************/

void
IO_store_rgb_actcall(IO_store_rgb, Comment_Area, callData)
	Widget IO_store_rgb;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;
	
if (flag_help_only){
      hproc_sauve_imrgb();
      return;
}
if (flag_help) hproc_sauve_imrgb();

IO_load_image_file_widget = 
	build_IO_store_post_file_widget(IO_store_rgb, 4, panel_titres[19]);
XtManageChild(IO_load_image_file_widget);
}


/******************************************************
/   activateCallback for Widget  IO_store_melanie
/*****************************************************/

void
IO_store_melanie_actcall(IO_store_melanie, Comment_Area, callData)
	Widget IO_store_melanie;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;
	
IO_load_image_file_widget = 
	build_IO_store_post_file_widget(IO_store_melanie, 8, panel_titres[21]);
XtManageChild(IO_load_image_file_widget);
}



/******************************************************
/   activateCallback for Widget  IO_store_sun
/*****************************************************/

void
IO_store_sun_actcall(IO_store_sun, Comment_Area, callData)
	Widget IO_store_sun;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;
	
if (flag_help_only){
      hproc_write_rasterfile();
      return;
}
if (flag_help) hproc_write_rasterfile();

IO_load_image_file_widget = 
	build_IO_store_post_file_widget(IO_store_sun, 5, panel_titres[20]);
XtManageChild(IO_load_image_file_widget);
}


/******************************************************
/   activateCallback for Widget  IO_postscript 
/*****************************************************/

void
IO_postscript_actcall(IO_postscript, Comment_Area, callData)
	Widget IO_postscript;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) laser_help_proc();
}


/******************************************************
/   activateCallback for Widget  IO_postscript_normal
/*****************************************************/

void
IO_postscript_normal_actcall(IO_postscript_normal, Comment_Area, callData)
	Widget IO_postscript_normal;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;
	
if (flag_help_only){
      hproc_laser_Gnature();
      return;
}
if (flag_help) hproc_laser_Gnature();

IO_load_image_file_widget = 
	build_IO_store_post_file_widget(IO_postscript_normal, 6, panel_titres[22]);
XtManageChild(IO_load_image_file_widget);
}


/******************************************************
/   activateCallback for Widget  IO_postscript_maximum
/*****************************************************/

void
IO_postscript_maximum_actcall(IO_postscript_maximum, Comment_Area, callData)
	Widget IO_postscript_maximum;
	Widget Comment_Area;
	caddr_t callData;
{
Widget IO_load_image_file_widget;
	
if (flag_help_only){
      hproc_laser_Gmaximum();
      return;
}
if (flag_help) hproc_laser_Gmaximum();

IO_load_image_file_widget = 
	build_IO_store_post_file_widget(IO_postscript_maximum, 7, panel_titres[23]);
XtManageChild(IO_load_image_file_widget);
}


/******************************************************
/   activateCallback for Widget  DISPLAY
/*****************************************************/

void
DISPLAY_actcall(DISPLAY, Comment_Area, callData)
	Widget DISPLAY;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) display_help_proc();
}

/******************************************************
/   activateCallback for Widget  DISPLAY_show
/*****************************************************/

void
DISPLAY_show_actcall(DISPLAY_show, Comment_Area, callData)
	Widget DISPLAY_show;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) affiche_help_proc();
}



/******************************************************
/   activateCallback for Widget  DISPLAY_show_threshold 
/*****************************************************/

void
DISPLAY_show_threshold_actcall(DISPLAY_show_threshold, Comment_Area, callData)
	Widget DISPLAY_show_threshold;
	Widget Comment_Area;
	caddr_t callData;
{
Widget DISPLAY_show_image_widget;
	
if (flag_help_only){
      hproc_seuil();
      return;
}
if (flag_help) hproc_seuil();

DISPLAY_show_image_widget = 
	build_DISPLAY_show_image_widget(DISPLAY_show_threshold, 1, 1, panel_titres[30]);
XtManageChild(DISPLAY_show_image_widget);
}


/******************************************************
/   activateCallback for Widget  DISPLAY_show_floydst 
/*****************************************************/

void
DISPLAY_show_floydst_actcall(DISPLAY_show_floydst, Comment_Area, callData)
	Widget DISPLAY_show_floydst;
	Widget Comment_Area;
	caddr_t callData;
{
Widget DISPLAY_show_image_widget;
	
if (flag_help_only){
      hproc_report_erreur();
      return;
}
if (flag_help) hproc_report_erreur();	

DISPLAY_show_image_widget = 
	build_DISPLAY_show_image_widget(DISPLAY_show_floydst, 1, 2, panel_titres[31]);
XtManageChild(DISPLAY_show_image_widget);
}


/******************************************************
/   activateCallback for Widget  DISPLAY_show_graytonelin 
/*****************************************************/

void
DISPLAY_show_graytonelin_actcall(DISPLAY_show_graytonelin, Comment_Area, callData)
	Widget DISPLAY_show_graytonelin;
	Widget Comment_Area;
	caddr_t callData;
{
Widget DISPLAY_show_image_widget;
	
if (flag_help_only){
      hproc_gris_lin();
      return;
}
if (flag_help) hproc_gris_lin();

DISPLAY_show_image_widget = 
	build_DISPLAY_show_image_widget(DISPLAY_show_graytonelin, 1, 3, panel_titres[32]);
XtManageChild(DISPLAY_show_image_widget);
}


/******************************************************
/   activateCallback for Widget  DISPLAY_show_graytonelog 
/*****************************************************/

void
DISPLAY_show_graytonelog_actcall(DISPLAY_show_graytonelog, Comment_Area, callData)
	Widget DISPLAY_show_graytonelog;
	Widget Comment_Area;
	caddr_t callData;
{
Widget DISPLAY_show_image_widget;
	
if (flag_help_only){
      hproc_gris_log();
      return;
}
if (flag_help) hproc_gris_log();

DISPLAY_show_image_widget = 
	build_DISPLAY_show_image_widget(DISPLAY_show_graytonelog, 1, 4, panel_titres[33]);
XtManageChild(DISPLAY_show_image_widget);
}


/******************************************************
/   activateCallback for Widget  DISPLAY_show_rgbdirect 
/*****************************************************/

void
DISPLAY_show_rgbdirect_actcall(DISPLAY_show_rgbdirect, Comment_Area, callData)
	Widget DISPLAY_show_rgbdirect;
	Widget Comment_Area;
	caddr_t callData;
{
Widget DISPLAY_show_image_widget;
	
if (flag_help_only){
       hproc_couleur_rgb();
       return;
}
if (flag_help) hproc_couleur_rgb();


DISPLAY_show_image_widget = 
	build_DISPLAY_show_image_widget(DISPLAY_show_rgbdirect, 3, 5, panel_titres[34]);
XtManageChild(DISPLAY_show_image_widget);
}


/******************************************************
/   activateCallback for Widget  DISPLAY_show_rgbfloydst 
/*****************************************************/

void
DISPLAY_show_rgbfloydst_actcall(DISPLAY_show_rgbfloydst, Comment_Area, callData)
	Widget DISPLAY_show_rgbfloydst;
	Widget Comment_Area;
	caddr_t callData;
{
Widget DISPLAY_show_image_widget;
	
if (flag_help_only){
      hproc_rgb_reporterreur();
      return;
}
if (flag_help) hproc_rgb_reporterreur();

DISPLAY_show_image_widget = 
	build_DISPLAY_show_image_widget(DISPLAY_show_rgbfloydst, 3, 6,  panel_titres[35]);
XtManageChild(DISPLAY_show_image_widget);
}


/******************************************************
/   activateCallback for Widget  DISPLAY_3Dpersp 
/*****************************************************/

void
DISPLAY_3Dpersp_actcall(DISPLAY_3Dpersp, Comment_Area, callData)
	Widget DISPLAY_3Dpersp;
	Widget Comment_Area;
	caddr_t callData;
{
  if (flag_help_only){
      cache_help_proc();
      return;
  }
  if (flag_help) cache_help_proc();
}


/******************************************************
/   activateCallback for Widget  DISPLAY_lookup_table_edit 
/*****************************************************/

void
DISPLAY_lookup_table_edit_actcall(DISPLAY_lookup_table_edit, Comment_Area, callData)
	Widget DISPLAY_lookup_table_edit;
	Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only){
      hproc_MapEdit();
      return;
}
if (flag_help) hproc_MapEdit();

if (!flag_mapedit_open) Build_mapedit(gLabowidget);
flag_mapedit_open = true;
}


/******************************************************
/   activateCallback for Widget  PREPROCESSING
/*****************************************************/

void
PREPROCESSING_actcall(PREPROCESSING, Comment_Area, callData)
	Widget PREPROCESSING;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) preprocess_help_proc();
}


/******************************************************
/   activateCallback for Widget  PRE_PRO_optionsl 
/*****************************************************/

void
PREPRO_histo_equal_actcall(PREPRO_histo_equal, Comment_Area, callData)
	Widget PREPRO_histo_equal;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only){
      hproc_egal_histo();
      return;
}
if (flag_help) hproc_egal_histo();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PREPRO_histo_equal,1, panel_titres[40]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PREPRO_enhancement
/*****************************************************/

void
PREPRO_enhancement_actcall(PREPRO_enhancement, Comment_Area, callData)
	Widget PREPRO_enhancement;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) rehauss_help_proc();
}


/******************************************************
/   activateCallback for Widget  PREPRO_enhanc_median_filter 
/*****************************************************/

void
PREPRO_enhanc_median_filter_actcall(PREPRO_enhanc_median_filter, Comment_Area, callData)
	Widget PREPRO_enhanc_median_filter;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;

if (flag_help_only){
      hproc_filtre_median();
      return;
}
if (flag_help) hproc_filtre_median();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PREPRO_enhanc_median_filter,8, panel_titres[41]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PREPRO_enhanc_high_pass_filter 
/*****************************************************/

void
PREPRO_enhanc_high_pass_filter_actcall(PREPRO_enhanc_high_pass_filter, Comment_Area, callData)
	Widget PREPRO_enhanc_high_pass_filter;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;

if (flag_help_only) {
      hproc_filtre_passhaut();
      return;
}
if (flag_help) hproc_filtre_passhaut();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PREPRO_enhanc_high_pass_filter,9, panel_titres[42]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PREPRO_filters
/*****************************************************/

void
PREPRO_filters_actcall(PREPRO_filters, Comment_Area, callData)
	Widget PREPRO_filters;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) 
{
freqfltr_help_proc();
hproc_filtre_hamming();
hproc_filtre_hanning();
hproc_filtre_gauss();
}
}


/******************************************************
/   activateCallback for Widget  PREPRO_hamming 
/*****************************************************/

void
PREPRO_hamming_actcall(PREPRO_hamming, Comment_Area, callData)
	Widget PREPRO_hamming;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only) {
      hproc_filtre_hamming();
      return;
}
if (flag_help) hproc_filtre_hamming();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PREPRO_hamming,10, panel_titres[43]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PREPRO_hanning 
/*****************************************************/

void
PREPRO_hanning_actcall(PREPRO_hanning, Comment_Area, callData)
	Widget PREPRO_hanning;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only) {
      hproc_filtre_hanning();
      return;
}
if (flag_help) hproc_filtre_hanning();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PREPRO_hanning,11, panel_titres[44]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PREPRO_gaussian 
/*****************************************************/

void
PREPRO_gaussian_actcall(PREPRO_gaussian, Comment_Area, callData)
	Widget PREPRO_gaussian;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only) {
      hproc_filtre_gauss();
      return;
}
if (flag_help) hproc_filtre_gauss();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PREPRO_gaussian,12, panel_titres[45]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PREPRO_correct_background 
/*****************************************************/

void
PREPRO_correct_background_actcall(PREPRO_correct_background, Comment_Area, callData)
	Widget PREPRO_correct_background;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_filtre_lin();
      return;
}
if (flag_help) hproc_filtre_lin();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PREPRO_correct_background,2, panel_titres[46]);
XtManageChild(PRE_PRO_options_widget);
}



/******************************************************
/   activateCallback for Widget  PROCESSING
/*****************************************************/

void
PROCESSING_actcall(PROCESSING, Comment_Area, callData)
	Widget PROCESSING;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) process_help_proc();
}


/******************************************************
/   activateCallback for Widget  PROCESS_thresh
/*****************************************************/

void
PROCESS_thresh_actcall(PROCESS_thresh, Comment_Area, callData)
	Widget PROCESS_thresh;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) choixseuil_help_proc();
}


/******************************************************
/   activateCallback for Widget  PROCESS_lapla_perc_histo 
/*****************************************************/

void
PROCESS_lapla_perc_histo_actcall(PROCESS_lapla_perc_histo, Comment_Area, callData)
	Widget PROCESS_lapla_perc_histo;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_laplacian_ptile();
      return;
}
if (flag_help) hproc_laplacian_ptile();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_lapla_perc_histo,13, panel_titres[50]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_dyn_threshold 
/*****************************************************/

void
PROCESS_dyn_threshold_actcall(PROCESS_dyn_threshold, Comment_Area, callData)
	Widget PROCESS_dyn_threshold;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_dyna_seuil();
      return;
}
if (flag_help) hproc_dyna_seuil();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_dyn_threshold,14, panel_titres[51]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_transforms
/*****************************************************/

void
PROCESS_transforms_actcall(PROCESS_transforms, Comment_Area, callData)
	Widget PROCESS_transforms;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) transforms_help_proc();
}


/******************************************************
/   activateCallback for Widget  PROCESS_complex_fourier_2D 
/*****************************************************/

void
PROCESS_complex_fourier_2D_actcall(PROCESS_complex_fourier_2D, Comment_Area, callData)
	Widget PROCESS_complex_fourier_2D;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_trans_Four_direct();
      return;
}
if (flag_help) hproc_trans_Four_direct();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_complex_fourier_2D,31, panel_titres[52]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_complex_inverse_fourier_2D 
/*****************************************************/

void
PROCESS_complex_inverse_fourier_2D_actcall(PROCESS_complex_inverse_fourier_2D, Comment_Area, callData)
	Widget PROCESS_complex_inverse_fourier_2D;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_trans_Four_inverse();
      return;
}
if (flag_help) hproc_trans_Four_inverse();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_complex_inverse_fourier_2D,32, panel_titres[53]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_complex_optical_fourier_2D 
/*****************************************************/

void
PROCESS_complex_optical_fourier_2D_actcall(PROCESS_complex_optical_fourier_2D, Comment_Area, callData)
	Widget PROCESS_complex_optical_fourier_2D;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_trans_Four_opt_direct();
      return;
}
if (flag_help) hproc_trans_Four_opt_direct();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_complex_optical_fourier_2D,33, panel_titres[54]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_complex_opt_inv_fourier_2D 
/*****************************************************/

void
PROCESS_complex_opt_inv_fourier_2D_actcall(PROCESS_complex_opt_inv_fourier_2D, Comment_Area, callData)
	Widget PROCESS_complex_opt_inv_fourier_2D;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_trans_Four_opt_inverse();
      return;
}
if (flag_help) hproc_trans_Four_opt_inverse();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_complex_opt_inv_fourier_2D,34, panel_titres[55]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_real_fourier_2D 
/*****************************************************/

void
PROCESS_real_fourier_2D_actcall(PROCESS_real_fourier_2D, Comment_Area, callData)
	Widget PROCESS_real_fourier_2D;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_trans_Four_direct();
      return;
}
if (flag_help) hproc_trans_Four_direct();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_real_fourier_2D,41, panel_titres[56]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_real_optical_fourier_2D 
/*****************************************************/

void
PROCESS_real_optical_fourier_2D_actcall(PROCESS_real_optical_fourier_2D, Comment_Area, callData)
	Widget PROCESS_real_optical_fourier_2D;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_trans_Four_opt_direct();
      return;
}
if (flag_help) hproc_trans_Four_opt_direct();

PRE_PRO_options_widget =
	build_PRE_PRO_options_widget(PROCESS_real_optical_fourier_2D,42, panel_titres[57]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESSING_convolution
/*****************************************************/

void
PROCESS_convolution_actcall(PROCESSING_convolution, Comment_Area, callData)
	Widget PROCESSING_convolution;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) convcorr_help_proc();
}


/******************************************************
/   activateCallback for Widget  PROCESS_convol_createmask 
/*****************************************************/

void
PROCESS_convol_createmask_actcall(PROCESS_convol_createmask, Comment_Area, callData)
	Widget PROCESS_convol_createmask;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only){
      hproc_creer_masq();
      return;
}
if (flag_help) hproc_creer_masq();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_convol_createmask,5, panel_titres[58]);

XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESSING_convol
/*****************************************************/

void
PROCESS_convol_actcall(PROCESSING_convol, Comment_Area, callData)
	Widget PROCESSING_convol;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) 
  {
    convol_help_proc();
    hproc_convol_masq();
    hproc_convol_image();
  }
}


/******************************************************
/   activateCallback for Widget  PROCESS_convol_mask 
/*****************************************************/

void
PROCESS_convol_mask_actcall(PROCESS_convol_mask, Comment_Area, callData)
	Widget PROCESS_convol_mask;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){	
      hproc_convol_masq();
      return;
}
if (flag_help) hproc_convol_masq();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_convol_mask,15, panel_titres[59]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_convol_image 
/*****************************************************/

void
PROCESS_convol_image_actcall(PROCESS_convol_image, Comment_Area, callData)
	Widget PROCESS_convol_image;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){	
      hproc_convol_image();
      return;
}
if (flag_help) hproc_convol_image();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_convol_image,61, panel_titres[60]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESSING_correl
/*****************************************************/

void
PROCESS_correl_actcall(PROCESSING_correl, Comment_Area, callData)
	Widget PROCESSING_correl;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) 
  {
    correl_help_proc();
    hproc_correl_masq();
    hproc_correl_image();
  }
}


/******************************************************
/   activateCallback for Widget  PROCESS_correl_mask 
/*****************************************************/

void
PROCESS_correl_mask_actcall(PROCESS_correl_mask, Comment_Area, callData)
	Widget PROCESS_correl_mask;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){	
      hproc_correl_masq();
      return;
}
if (flag_help) hproc_correl_masq();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_correl_mask,16, panel_titres[61]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_correl_image 
/*****************************************************/

void
PROCESS_correl_image_actcall(PROCESS_correl_image, Comment_Area, callData)
	Widget PROCESS_correl_image;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){	
      hproc_correl_image();
      return;
}
if (flag_help) hproc_correl_image();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_correl_image,62, panel_titres[62]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESSING_edges
/*****************************************************/

void
PROCESS_edges_actcall(PROCESSING_edges, Comment_Area, callData)
	Widget PROCESSING_edges;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) contour_help_proc();
}


/******************************************************
/   activateCallback for Widget  PROCESSING_edges_sobel
/*****************************************************/

void
PROCESS_edges_sobel_actcall(PROCESSING_edges, Comment_Area, callData)
	Widget PROCESSING_edges;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) hproc_sobel();
}


/******************************************************
/   activateCallback for Widget  PROCESS_edges_sobel_racine 
/*****************************************************/

void
PROCESS_edges_sobel_racine_actcall(PROCESS_edges_sobel_racine, Comment_Area, callData)
	Widget PROCESS_edges_sobel_racine;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	    
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_edges_sobel_racine,71, panel_titres[63]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_edges_sobel_absolue 
/*****************************************************/

void
PROCESS_edges_sobel_absolue_actcall(PROCESS_edges_sobel_absolue, Comment_Area, callData)
	Widget PROCESS_edges_sobel_absolue;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_edges_sobel_absolue,72, panel_titres[64]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESSING_edges_laplacian
/*****************************************************/

void
PROCESS_edges_laplacian_actcall(PROCESSING_edges, Comment_Area, callData)
	Widget PROCESSING_edges;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) hproc_laplace();
}


/******************************************************
/   activateCallback for Widget  PROCESS_edges_laplacian_1 
/*****************************************************/

void
PROCESS_edges_laplacian_1_actcall(PROCESS_edges_laplacian_1, Comment_Area, callData)
	Widget PROCESS_edges_laplacian_1;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_edges_laplacian_1,73, panel_titres[65]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_edges_laplacian_2
/*****************************************************/

void
PROCESS_edges_laplacian_2_actcall(PROCESS_edges_laplacian_2, Comment_Area, callData)
	Widget PROCESS_edges_laplacian_2;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_edges_laplacian_2,74, panel_titres[66]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_edges_laplacian_3 
/*****************************************************/

void
PROCESS_edges_laplacian_3_actcall(PROCESS_edges_laplacian_3, Comment_Area, callData)
	Widget PROCESS_edges_laplacian_3;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_edges_laplacian_3,75, panel_titres[67]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESSING_edges_roberts
/*****************************************************/

void
PROCESS_edges_roberts_actcall(PROCESSING_edges, Comment_Area, callData)
	Widget PROCESSING_edges;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) hproc_roberts();
}


/******************************************************
/   activateCallback for Widget  PROCESS_edges_roberts_racine 
/*****************************************************/

void
PROCESS_edges_roberts_racine_actcall(PROCESS_edges_roberts_racine, Comment_Area, callData)
	Widget PROCESS_edges_roberts_racine;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_edges_roberts_racine,76, panel_titres[68]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_edges_roberts_absolue 
/*****************************************************/

void
PROCESS_edges_roberts_absolue_actcall(PROCESS_edges_roberts_absolue, Comment_Area, callData)
	Widget PROCESS_edges_roberts_absolue;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
PRE_PRO_options_widget =
	build_PRE_PRO_options_widget(PROCESS_edges_roberts_absolue,77, panel_titres[69]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_edges_frei_chen 
/*****************************************************/

void
PROCESS_edges_frei_chen_actcall(PROCESS_edges_frei_chen, Comment_Area, callData)
	Widget PROCESS_edges_frei_chen;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only){
      hproc_frei_chen();
      return;
}
if (flag_help) hproc_frei_chen();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_edges_frei_chen,78, panel_titres[70]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_edges_mero_vassy 
/*****************************************************/

void
PROCESS_edges_mero_vassy_actcall(PROCESS_edges_mero_vassy, Comment_Area, callData)
	Widget PROCESS_edges_mero_vassy;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only){
      hproc_mero_vassy();
      return;
}
if (flag_help) hproc_mero_vassy();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_edges_mero_vassy,79, panel_titres[71]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_edges_zero_crossing 
/*****************************************************/

void
PROCESS_edges_zero_crossing_actcall(PROCESS_edges_zero_crossing, Comment_Area, callData)
	Widget PROCESS_edges_zero_crossing;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only){
      hproc_zero_cross();
      return;
}
if (flag_help) hproc_zero_cross();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_edges_zero_crossing,70, panel_titres[72]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_edges_ridge_riding 
/*****************************************************/

void
PROCESS_edges_ridge_riding_actcall(PROCESS_edges_ridge_riding, Comment_Area, callData)
	Widget PROCESS_edges_ridge_riding;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only){
      hproc_ridge_ride();
      return;
}
if (flag_help) hproc_ridge_ride();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_edges_ridge_riding,17, panel_titres[73]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESSING_regions
/*****************************************************/

void
PROCESS_regions_actcall(PROCESSING_regions, Comment_Area, callData)
	Widget PROCESSING_regions;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) segment_help_proc();
}


/******************************************************
/   activateCallback for Widget  PROCESS_region_growing 
/*****************************************************/

void
PROCESS_region_growing_actcall(PROCESS_region_growing, Comment_Area, callData)
	Widget PROCESS_region_growing;
	Widget Comment_Area;
	caddr_t callData;
{
  if (flag_help_only){
    hproc_region_grow();
    return;
  }
  if (flag_help) hproc_region_grow();

  sprintf(buf, labeltabs[7]);
  write_master(buf);
  sprintf(buf, "\n");
  write_master(buf);

  Build_reg_growing();
}


/******************************************************
/   activateCallback for Widget  PROCESSING_regions_OPR
/*****************************************************/

void
PROCESS_regions_OPR_actcall(PROCESSING_regions_OPR, Comment_Area, callData)
	Widget PROCESSING_regions_OPR;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) opr_help_proc();
}


/******************************************************
/   activateCallback for Widget  PROCESS_OPR_graytone 
/*****************************************************/

void
PROCESS_OPR_graytone_actcall(PROCESS_OPR_graytone, Comment_Area, callData)
	Widget PROCESS_OPR_graytone;
	Widget Comment_Area;
	caddr_t callData;
{
	/* ADD CALLBACK CODE HERE */
}


/******************************************************
/   activateCallback for Widget  PROCESS_OPR_rgb 
/*****************************************************/

void
PROCESS_OPR_rgb_actcall(PROCESS_OPR_rgb, Comment_Area, callData)
	Widget PROCESS_OPR_rgb;
	Widget Comment_Area;
	caddr_t callData;
{
	/* ADD CALLBACK CODE HERE */
}

/*************************************SEGMENT4.C************************************/
/******************************************************
/   activateCallback for Widget  PROCESS_graph_construction 
/*****************************************************/
/************
void
PROCESS_graph_construction_actcall(PROCESS_graph_construction, Comment_Area, callData)
	Widget PROCESS_graph_construction;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
PRE_PRO_options_widget = build_PRE_PRO_options_widget(PROCESS_graph_construction,110);
XtManageChild(PRE_PRO_options_widget);
}
*****/

/******************************************************
/   activateCallback for Widget  PROCESS_graph_image 
/*****************************************************/
/************
void
PROCESS_graph_image_actcall(PROCESS_graph_image, Comment_Area, callData)
	Widget PROCESS_graph_image;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
PRE_PRO_options_widget = build_PRE_PRO_options_widget(PROCESS_graph_image,111);
XtManageChild(PRE_PRO_options_widget);
}
*****/

/******************************************************
/   activateCallback for Widget  PROCESS_region_extraction 
/*****************************************************/
/************
void
PROCESS_region_extraction_actcall(PROCESS_region_extraction, Comment_Area, callData)
	Widget PROCESS_region_extraction;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
PRE_PRO_options_widget = build_PRE_PRO_options_widget(PROCESS_region_extraction,112);
XtManageChild(PRE_PRO_options_widget);
}
*****/

/******************************************************
/   activateCallback for Widget  PROCESS_elimin_small_regions 
/*****************************************************/
/************
void
PROCESS_elimin_small_regions_actcall(PROCESS_elim_small_regions, Comment_Area, callData)
	Widget PROCESS_elim_small_regions;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
PRE_PRO_options_widget = build_PRE_PRO_options_widget(PROCESS_elim_small_regions,113);
XtManageChild(PRE_PRO_options_widget);
}
*****/
/*************************************************************************************/


/******************************************************
/   activateCallback for Widget  PROCESS_binary_morpho 
/*****************************************************/
/* anciennement proc_entree_morphbin 		     */
/*****************************************************/
void
PROCESS_binary_morpho_actcall(PROCESS_binary_morpho, Comment_Area, callData)
	Widget PROCESS_binary_morpho;
	Widget Comment_Area;
	caddr_t callData;
{
  if (flag_help_only){
	 hproc_entree_morphbin();
	 return;
  }
  if (flag_help) hproc_entree_morphbin();  
  build_MenuBar_6(Menu_Morpho_Binaire);

  sprintf(buf,mastertabs[97]);
  write_master(buf);
  entree_morpho (0);

  XtManageChild(Menu_Morpho_Binaire);
  XtManageChild(QUIT_Morpho_Bin);
}


/******************************************************
/   activateCallback for Widget  PROCESS_gray_scale_morpho
/*****************************************************/

void
PROCESS_gray_scale_morpho_actcall(PROCESS_gray_scale_morpho, Comment_Area, callData)
	Widget PROCESS_gray_scale_morpho;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) morphniv_help_proc();
}


/******************************************************
/   activateCallback for Widget  PROCESS_erosion
/*****************************************************/

void
PROCESS_erosion_actcall(PROCESS_erosion, Comment_Area, callData)
	Widget PROCESS_erosion;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) 
  {
    hproc_erode_sphere();
    hproc_erode_cone();
    hproc_erode_cylinder();
    hproc_erode_gauss();
    hproc_erode_plan_image();
  }
}


/******************************************************
/   activateCallback for Widget  PROCESS_erosion_sphere 
/*****************************************************/

void
PROCESS_erosion_sphere_actcall(PROCESS_erosion_sphere, Comment_Area, callData)
	Widget PROCESS_erosion_sphere;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_erode_sphere();
      return;
}
if (flag_help) hproc_erode_sphere();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_erosion_sphere,80, panel_titres[80]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_erosion_cone 
/*****************************************************/

void
PROCESS_erosion_cone_actcall(PROCESS_erosion_cone, Comment_Area, callData)
	Widget PROCESS_erosion_cone;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_erode_cone();
      return;
}
if (flag_help) hproc_erode_cone();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_erosion_cone,81, panel_titres[81]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_erosion_cylinder 
/*****************************************************/

void
PROCESS_erosion_cylinder_actcall(PROCESS_erosion_cylinder, Comment_Area, callData)
	Widget PROCESS_erosion_cylinder;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_erode_cylinder();
      return;
}
if (flag_help) hproc_erode_cylinder();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_erosion_cylinder,82, panel_titres[82]);
XtManageChild(PRE_PRO_options_widget);
}



/******************************************************
/   activateCallback for Widget  PROCESS_erosion_gaussian 
/*****************************************************/

void
PROCESS_erosion_gaussian_actcall(PROCESS_erosion_gaussian, Comment_Area, callData)
	Widget PROCESS_erosion_gaussian;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_erode_gauss();
      return;
}
if (flag_help) hproc_erode_gauss();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_erosion_gaussian,83, panel_titres[83]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_erosion_imageplane 
/*****************************************************/

void
PROCESS_erosion_imageplane_actcall(PROCESS_erosion_imageplane, Comment_Area, callData)
	Widget PROCESS_erosion_imageplane;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_erode_plan_image();
      return;
}
if (flag_help) hproc_erode_plan_image();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_erosion_imageplane,96, panel_titres[84]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_dilatation
/*****************************************************/

void
PROCESS_dilatation_actcall(PROCESS_dilatation, Comment_Area, callData)
	Widget PROCESS_dilatation;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) 
  {
    hproc_dilate_sphere();
    hproc_dilate_cone();
    hproc_dilate_cylinder();
    hproc_dilate_gauss();
    hproc_dilate_plan_image();
  }
}


/******************************************************
/   activateCallback for Widget  PROCESS_dilatation_sphere 
/*****************************************************/

void
PROCESS_dilatation_sphere_actcall(PROCESS_dilatation_sphere, Comment_Area, callData)
	Widget PROCESS_dilatation_sphere;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_dilate_sphere();
      return;
}
if (flag_help) hproc_dilate_sphere();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_dilatation_sphere,84, panel_titres[85]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_dilatation_cone 
/*****************************************************/

void
PROCESS_dilatation_cone_actcall(PROCESS_dilatation_cone, Comment_Area, callData)
	Widget PROCESS_dilatation_cone;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_dilate_cone();
      return;
}
if (flag_help) hproc_dilate_cone();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_dilatation_cone,85, panel_titres[86]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_dilatation_cylinder 
/*****************************************************/

void
PROCESS_dilatation_cylinder_actcall(PROCESS_dilatation_cylinder, Comment_Area, callData)
	Widget PROCESS_dilatation_cylinder;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_dilate_cylinder();
      return;
}
if (flag_help) hproc_dilate_cylinder();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_dilatation_cylinder,86, panel_titres[87]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_dilatation_gaussian 
/*****************************************************/

void
PROCESS_dilatation_gaussian_actcall(PROCESS_dilatation_gaussian, Comment_Area, callData)
	Widget PROCESS_dilatation_gaussian;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_dilate_gauss();
      return;
}
if (flag_help) hproc_dilate_gauss();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_dilatation_gaussian,87, panel_titres[88]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_dilatation_imageplane 
/*****************************************************/

void
PROCESS_dilatation_imageplane_actcall(PROCESS_dilatation_imageplane, Comment_Area, callData)
	Widget PROCESS_dilatation_imageplane;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_dilate_plan_image();
      return;
}
if (flag_help) hproc_dilate_plan_image();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_dilatation_imageplane,97, panel_titres[89]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_opening
/*****************************************************/

void
PROCESS_opening_actcall(PROCESS_opening, Comment_Area, callData)
	Widget PROCESS_opening;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) 
  {
    hproc_ouverture_sphere();
    hproc_ouverture_cone();
    hproc_ouverture_cylinder();
    hproc_ouverture_gauss();
    hproc_ouverture_plan_image();
  }
}


/******************************************************
/   activateCallback for Widget  PROCESS_opening_sphere 
/*****************************************************/

void
PROCESS_opening_sphere_actcall(PROCESS_opening_sphere, Comment_Area, callData)
	Widget PROCESS_opening_sphere;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_ouverture_sphere();
      return;
}
if (flag_help) hproc_ouverture_sphere();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_opening_sphere,88, panel_titres[90]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_opening_cone 
/*****************************************************/

void
PROCESS_opening_cone_actcall(PROCESS_opening_cone, Comment_Area, callData)
	Widget PROCESS_opening_cone;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_ouverture_cone();
      return;
}
if (flag_help) hproc_ouverture_cone();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_opening_cone,89, panel_titres[91]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_opening_cylinder 
/*****************************************************/

void
PROCESS_opening_cylinder_actcall(PROCESS_opening_cylinder, Comment_Area, callData)
	Widget PROCESS_opening_cylinder;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_ouverture_cylinder();
      return;
}
if (flag_help) hproc_ouverture_cylinder();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_opening_cylinder,90, panel_titres[92]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_opening_gaussian 
/*****************************************************/

void
PROCESS_opening_gaussian_actcall(PROCESS_opening_gaussian, Comment_Area, callData)
	Widget PROCESS_opening_gaussian;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_ouverture_gauss();
      return;
}
if (flag_help) hproc_ouverture_gauss();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_opening_gaussian,91, panel_titres[93]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_opening_imageplane 
/*****************************************************/

void
PROCESS_opening_imageplane_actcall(PROCESS_opening_imageplane, Comment_Area, callData)
	Widget PROCESS_opening_imageplane;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_ouverture_plan_image();
      return;
}
if (flag_help) hproc_ouverture_plan_image();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_opening_imageplane,98, panel_titres[94]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_closure
/*****************************************************/

void
PROCESS_closure_actcall(PROCESS_closure, Comment_Area, callData)
	Widget PROCESS_closure;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) 
  {
    hproc_fermeture_sphere();
    hproc_fermeture_cone();
    hproc_fermeture_cylinder();
    hproc_fermeture_gauss();
    hproc_fermeture_plan_image();
  }
}

/******************************************************
/   activateCallback for Widget  PROCESS_closure_sphere 
/*****************************************************/

void
PROCESS_closure_sphere_actcall(PROCESS_closure_sphere, Comment_Area, callData)
	Widget PROCESS_closure_sphere;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_fermeture_sphere();
      return;
}
if (flag_help) hproc_fermeture_sphere();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_closure_sphere,92, panel_titres[95]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_closure_cone 
/*****************************************************/

void
PROCESS_closure_cone_actcall(PROCESS_closure_cone, Comment_Area, callData)
	Widget PROCESS_closure_cone;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_fermeture_cone();
      return;
}
if (flag_help) hproc_fermeture_cone();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_closure_cone,93, panel_titres[96]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_closure_cylinder 
/*****************************************************/

void
PROCESS_closure_cylinder_actcall(PROCESS_closure_cylinder, Comment_Area, callData)
	Widget PROCESS_closure_cylinder;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_fermeture_cylinder();
      return;
}
if (flag_help) hproc_fermeture_cylinder();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_closure_cylinder,94, panel_titres[97]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_closure_gaussian 
/*****************************************************/

void
PROCESS_closure_gaussian_actcall(PROCESS_closure_gaussian, Comment_Area, callData)
	Widget PROCESS_closure_gaussian;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_fermeture_gauss();
      return;
}
if (flag_help) hproc_fermeture_gauss();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_closure_gaussian,95, panel_titres[98]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  PROCESS_closure_imageplane 
/*****************************************************/

void
PROCESS_closure_imageplane_actcall(PROCESS_closure_imageplane, Comment_Area, callData)
	Widget PROCESS_closure_imageplane;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_fermeture_plan_image();
      return;
}
if (flag_help) hproc_fermeture_plan_image();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(PROCESS_closure_imageplane,99, panel_titres[99]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  MEASURES
/*****************************************************/

void
MEASURES_actcall(MEASURES, Comment_Area, callData)
	Widget MEASURES;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) measures_help_proc();
}



/******************************************************
/   activateCallback for Widget  MEASURES_histogram
/*****************************************************/

void
MEASURES_histogram_actcall(MEASURES_histogram, Comment_Area, callData)
	Widget MEASURES_histogram;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) hist_help_proc();
}


/******************************************************
/   activateCallback for Widget  MEASURES_histo_calculate 
/*****************************************************/

void
MEASURES_histo_calculate_actcall(MEASURES_histo_calculate, Comment_Area, callData)
	Widget MEASURES_histo_calculate;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_calcule_hist();
      return;
}
if (flag_help) hproc_calcule_hist();	

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(MEASURES_histo_calculate,200, panel_titres[110]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  MEASURES_histo_show 
/*****************************************************/

void
MEASURES_histo_show_actcall(MEASURES_histo_show, Comment_Area, callData)
	Widget MEASURES_histo_show;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_affiche_hist();
      return;
}
if (flag_help) hproc_affiche_hist();	

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(MEASURES_histo_show,201, panel_titres[111]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  MEASURES_histo_print 
/*****************************************************/

void
MEASURES_histo_print_actcall(MEASURES_histo_print, Comment_Area, callData)
	Widget MEASURES_histo_print;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_imprime_hist();
      return;
}
if (flag_help) hproc_imprime_hist();	

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(MEASURES_histo_print,202, panel_titres[112]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  MEASURES_image_stat 
/*****************************************************/

void
MEASURES_image_stat_actcall(MEASURES_image_stat, Comment_Area, callData)
	Widget MEASURES_image_stat;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only){ 
      hproc_calc_stat();
      return;
}
if (flag_help) hproc_calc_stat();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(MEASURES_image_stat, 203, panel_titres[113]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  MEASURES_colour_regions
/*****************************************************/

void
MEASURES_colour_regions_actcall(MEASURES_colour_regions, Comment_Area, callData)
	Widget MEASURES_colour_regions;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) color_help_proc();
}


/******************************************************
/   activateCallback for Widget  MEASURES_colour_fill
/*****************************************************/

void
MEASURES_colour_fill_actcall(MEASURES_colour_fill, Comment_Area, callData)
	Widget MEASURES_colour_fill;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) 
  {
    color_r_help_proc();
    hproc_fill_bc8();
    hproc_fill_bc4();
    hproc_fill_cc8();
    hproc_fill_cc4();
  }
}


/******************************************************
/   activateCallback for Widget  MEASURES_colour_fill_b0c8 
/*****************************************************/

void
MEASURES_colour_fill_b0c8_actcall(MEASURES_colour_fill_b0c8, Comment_Area, callData)
	Widget MEASURES_colour_fill_b0c8;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_fill_bc8();
      return;
}
if (flag_help) hproc_fill_bc8();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(MEASURES_colour_fill_b0c8, 210, panel_titres[114]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  MEASURES_colour_fill_b0c4 
/*****************************************************/

void
MEASURES_colour_fill_b0c4_actcall(MEASURES_colour_fill_b0c4, Comment_Area, callData)
	Widget MEASURES_colour_fill_b0c4;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_fill_bc4();
      return;
}
if (flag_help) hproc_fill_bc4();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(MEASURES_colour_fill_b0c4, 211, panel_titres[115]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  MEASURES_colour_fill_c0c8 
/*****************************************************/

void
MEASURES_colour_fill_c0c8_actcall(MEASURES_colour_fill_c0c8, Comment_Area, callData)
	Widget MEASURES_colour_fill_c0c8;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_fill_cc8();
      return;
}
if (flag_help) hproc_fill_cc8();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(MEASURES_colour_fill_c0c8, 212, panel_titres[116]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  MEASURES_colour_fill_c0c4 
/*****************************************************/

void
MEASURES_colour_fill_c0c4_actcall(MEASURES_colour_fill_c0c4, Comment_Area, callData)
	Widget MEASURES_colour_fill_c0c4;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
/*if (flag_help_only){
      hproc_fill_cc4();
      return;
}
if (flag_help) hproc_fill_cc4();
*/
PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(MEASURES_colour_fill_c0c4, 213, panel_titres[117]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  MEASURES_colour_save 
/*****************************************************/

void
MEASURES_colour_save_actcall(MEASURES_colour_save, Comment_Area, callData)
	Widget MEASURES_colour_save;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_sauver_objets_comptes();
      return;
}
if (flag_help) hproc_sauver_objets_comptes();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(MEASURES_colour_save, 214, panel_titres[118]);
XtManageChild(PRE_PRO_options_widget);
}



/******************************************************
/   activateCallback for Widget  MEASURES_power
/*****************************************************/

void
MEASURES_power_actcall(MEASURES_power, Comment_Area, callData)
	Widget MEASURES_power;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) puiss_help_proc();
}


/******************************************************
/   activateCallback for Widget  MEASURES_power_calculate 
/*****************************************************/

void
MEASURES_power_calculate_actcall(MEASURES_power_calculate, Comment_Area, callData)
	Widget MEASURES_power_calculate;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_puissance();
      return;
}
if (flag_help)  hproc_puissance();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(MEASURES_power_calculate, 215, panel_titres[119]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  MEASURES_power_cut_freq 
/*****************************************************/

void
MEASURES_power_cut_freq_actcall(MEASURES_power_cut_freq, Comment_Area, callData)
	Widget MEASURES_power_cut_freq;
	Widget Comment_Area;
	caddr_t callData;
{
Widget PRE_PRO_options_widget;
	
if (flag_help_only) {
      hproc_couper_freq();
      return;
}
if (flag_help) hproc_couper_freq();

PRE_PRO_options_widget = 
	build_PRE_PRO_options_widget(MEASURES_power_cut_freq, 216, panel_titres[120]);
XtManageChild(PRE_PRO_options_widget);
}


/******************************************************
/   activateCallback for Widget  AUXILIARY
/*****************************************************/

void
AUXILIARY_actcall(AUXILIARY, Comment_Area, callData)
	Widget AUXILIARY;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) aux_help_proc();
}


/******************************************************
/   activateCallback for Widget  AUXILIARY_convers
/*****************************************************/

void
AUXIL_convers_actcall(AUXILIARY_convers, Comment_Area, callData)
	Widget AUXILIARY_convers;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) convert_help_proc();
}


/******************************************************
/   activateCallback for Widget  AUXIL_convers_binary 
/*****************************************************/

void
AUXIL_convers_binary_actcall(AUXIL_convers_binary, Comment_Area, callData)
	Widget AUXIL_convers_binary;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_conversion;

if (flag_help_only){
	hproc_conv_bin();
	return;
}
if (flag_help) hproc_conv_bin();

AUXIL_conversion = build_IOplans_widget(AUXIL_convers_binary, -1, panel_titres[130], NULL);
XtManageChild(AUXIL_conversion);
}


/******************************************************
/   activateCallback for Widget  AUXIL_convers_byte 
/*****************************************************/

void
AUXIL_convers_byte_actcall(AUXIL_convers_byte, Comment_Area, callData)
	Widget AUXIL_convers_byte;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_conversion;

if (flag_help_only){
      hproc_conv_byte();
      return;
}
if (flag_help) hproc_conv_byte();

AUXIL_conversion = build_IOplans_widget(AUXIL_convers_byte, 0, panel_titres[131], NULL);
XtManageChild(AUXIL_conversion);
}


/******************************************************
/   activateCallback for Widget  AUXIL_convers_short 
/*****************************************************/

void
AUXIL_convers_short_actcall(AUXIL_convers_short, Comment_Area, callData)
	Widget AUXIL_convers_short;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_conversion;

if (flag_help_only){
      hproc_conv_short();
      return;
}
if (flag_help) hproc_conv_short();

AUXIL_conversion = build_IOplans_widget(AUXIL_convers_short, 1, panel_titres[132], NULL);
XtManageChild(AUXIL_conversion);
}


/******************************************************
/   activateCallback for Widget  AUXIL_convers_integer 
/*****************************************************/

void
AUXIL_convers_integer_actcall(AUXIL_convers_integer, Comment_Area, callData)
	Widget AUXIL_convers_integer;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_conversion;

if (flag_help_only){
      hproc_conv_integer();
      return;
}
if (flag_help) hproc_conv_integer();

AUXIL_conversion = build_IOplans_widget(AUXIL_convers_integer, 2, panel_titres[133], NULL);
XtManageChild(AUXIL_conversion);
}


/******************************************************
/   activateCallback for Widget  AUXIL_convers_real 
/*****************************************************/

void
AUXIL_convers_real_actcall(AUXIL_convers_real, Comment_Area, callData)
	Widget AUXIL_convers_real;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_conversion;

if (flag_help_only){
      hproc_conv_float();
      return;
}
if (flag_help) hproc_conv_float();

AUXIL_conversion = build_IOplans_widget(AUXIL_convers_real, 3, panel_titres[134], NULL);
XtManageChild(AUXIL_conversion);
}


/******************************************************
/   activateCallback for Widget  AUXIL_convers_complex 
/*****************************************************/

void
AUXIL_convers_complex_actcall(AUXIL_convers_complex, Comment_Area, callData)
	Widget AUXIL_convers_complex;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_conversion;

if (flag_help_only){
      hproc_conv_complex();
      return;
}
if (flag_help) hproc_conv_complex();

AUXIL_conversion = build_IOplans_widget(AUXIL_convers_complex, 4, panel_titres[135], NULL);
XtManageChild(AUXIL_conversion);
}


/******************************************************
/   activateCallback for Widget  AUXIL_convers_cart_pol 
/*****************************************************/

void
AUXIL_convers_cart_pol_actcall(AUXIL_convers_cart_pol, Comment_Area, callData)
	Widget AUXIL_convers_cart_pol;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_conversion;

if (flag_help_only){
      hproc_conv_cartpol();
      return;
}
if (flag_help) hproc_conv_cartpol();

AUXIL_conversion = build_IOplans_widget(AUXIL_convers_cart_pol, 5, panel_titres[136], NULL);
XtManageChild(AUXIL_conversion);
}


/******************************************************
/   activateCallback for Widget  AUXIL_convers_pol_cart 
/*****************************************************/

void
AUXIL_convers_pol_cart_actcall(AUXIL_convers_pol_cart, Comment_Area, callData)
	Widget AUXIL_convers_pol_cart;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_conversion;

if (flag_help_only){
      hproc_conv_polcart();
      return;
}
if (flag_help) hproc_conv_polcart();

AUXIL_conversion = build_IOplans_widget(AUXIL_convers_pol_cart, 6, panel_titres[137], NULL);
XtManageChild(AUXIL_conversion);
}


/******************************************************
/   activateCallback for Widget  AUXIL_convers_rgb_graytone 
/*****************************************************/

void
AUXIL_convers_rgb_graytone_actcall(AUXIL_convers_rgb_graytone, Comment_Area, callData)
	Widget AUXIL_convers_rgb_graytone;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_conversion;

if (flag_help_only){
      hproc_conv_rgbgray();
      return;
}
if (flag_help) hproc_conv_rgbgray();

AUXIL_conversion = 
	build_IOplans_widget(AUXIL_convers_rgb_graytone, 7, panel_titres[138], NULL);
XtManageChild(AUXIL_conversion);
}


/******************************************************
/   activateCallback for Widget  AUXILIARY_arithm
/*****************************************************/

void
AUXIL_arithm_actcall(AUXILIARY_arithm, Comment_Area, callData)
	Widget AUXILIARY_arithm;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) oparithm_help_proc();
}


/******************************************************
/   activateCallback for Widget  AUXIL_arithm_plus 
/*****************************************************/

void
AUXIL_arithm_plus_actcall(AUXIL_arithm_plus, Comment_Area, callData)
	Widget AUXIL_arithm_plus;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_arithm;

if (flag_help_only){
      hproc_oparithm_adddeuxplans();
      return;
}
if (flag_help) hproc_oparithm_adddeuxplans();

AUXIL_arithm = build_IOplans_widget(AUXIL_arithm_plus, 10, panel_titres[139], NULL);
XtManageChild(AUXIL_arithm);
}


/******************************************************
/   activateCallback for Widget  AUXIL_arithm_moins 
/*****************************************************/

void
AUXIL_arithm_moins_actcall(AUXIL_arithm_moins, Comment_Area, callData)
	Widget AUXIL_arithm_moins;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_arithm;

if (flag_help_only){
      hproc_oparithm_subdeuxplans();
      return;
}
if (flag_help) hproc_oparithm_subdeuxplans();

AUXIL_arithm = build_IOplans_widget(AUXIL_arithm_moins, 11, panel_titres[140], NULL);
XtManageChild(AUXIL_arithm);
}


/******************************************************
/   activateCallback for Widget  AUXIL_arithm_fois 
/*****************************************************/

void
AUXIL_arithm_fois_actcall(AUXIL_arithm_fois, Comment_Area, callData)
	Widget AUXIL_arithm_fois;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_arithm;

if (flag_help_only){
      hproc_oparithm_muldeuxplans();
      return;
}
if (flag_help) hproc_oparithm_muldeuxplans();

AUXIL_arithm = build_IOplans_widget(AUXIL_arithm_fois, 12, panel_titres[141], NULL);
XtManageChild(AUXIL_arithm);
}


/******************************************************
/   activateCallback for Widget  AUXIL_arithm_div 
/*****************************************************/

void
AUXIL_arithm_div_actcall(AUXIL_arithm_div, Comment_Area, callData)
	Widget AUXIL_arithm_div;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_arithm;

if (flag_help_only){
      hproc_oparithm_divdeuxplans();
      return;
}
if (flag_help) hproc_oparithm_divdeuxplans();

AUXIL_arithm = build_IOplans_widget(AUXIL_arithm_div, 13, panel_titres[142], NULL);
XtManageChild(AUXIL_arithm);
}


/******************************************************
/   activateCallback for Widget  AUXIL_arithm_plusconst 
/*****************************************************/

void
AUXIL_arithm_plusconst_actcall(AUXIL_arithm_plusconst, Comment_Area, callData)
	Widget AUXIL_arithm_plusconst;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_arithm;

if (flag_help_only){
      hproc_oparithm_addcte();
      return;
}
if (flag_help) hproc_oparithm_addcte();

AUXIL_arithm = build_IOplans_widget(AUXIL_arithm_plusconst, 14, panel_titres[143], NULL);
XtManageChild(AUXIL_arithm);
}


/******************************************************
/   activateCallback for Widget  AUXIL_arithm_moinsconst 
/*****************************************************/

void
AUXIL_arithm_moinsconst_actcall(AUXIL_arithm_moinsconst, Comment_Area, callData)
	Widget AUXIL_arithm_moinsconst;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_arithm;

if (flag_help_only){
      hproc_oparithm_subcte();
      return;
}
if (flag_help) hproc_oparithm_subcte();

AUXIL_arithm = build_IOplans_widget(AUXIL_arithm_moinsconst, 15, panel_titres[144], NULL);
XtManageChild(AUXIL_arithm);
}


/******************************************************
/   activateCallback for Widget  AUXIL_arithm_foisconst 
/*****************************************************/

void
AUXIL_arithm_foisconst_actcall(AUXIL_arithm_foisconst, Comment_Area, callData)
	Widget AUXIL_arithm_foisconst;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_arithm;

if (flag_help_only){
      hproc_oparithm_mulcte();
      return;
}
if (flag_help) hproc_oparithm_mulcte();

AUXIL_arithm = build_IOplans_widget(AUXIL_arithm_foisconst, 16, panel_titres[145], NULL);
XtManageChild(AUXIL_arithm);
}


/******************************************************
/   activateCallback for Widget  AUXIL_arithm_divconst 
/*****************************************************/

void
AUXIL_arithm_divconst_actcall(AUXIL_arithm_divconst, Comment_Area, callData)
	Widget AUXIL_arithm_divconst;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_arithm;

if (flag_help_only){
      hproc_oparithm_divcte();
      return;
}
if (flag_help) hproc_oparithm_divcte();

AUXIL_arithm = build_IOplans_widget(AUXIL_arithm_divconst, 17, panel_titres[146], NULL);
XtManageChild(AUXIL_arithm);
}


/******************************************************
/   activateCallback for Widget  AUXIL_arithm_fois2const 
/*****************************************************/

void
AUXIL_arithm_fois2const_actcall(AUXIL_arithm_fois2const, Comment_Area, callData)
	Widget AUXIL_arithm_fois2const;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_arithm;

if (flag_help_only){
      hproc_oparithm_mul_imagecomplexe_ctecomplex();
      return;
}
if (flag_help) hproc_oparithm_mul_imagecomplexe_ctecomplex();

AUXIL_arithm = build_IOplans_widget(AUXIL_arithm_fois2const, 20, panel_titres[147], NULL);
XtManageChild(AUXIL_arithm);
}


/******************************************************
/   activateCallback for Widget  AUXIL_arithm_fois4 
/*****************************************************/

void
AUXIL_arithm_fois4_actcall(AUXIL_arithm_fois4, Comment_Area, callData)
	Widget AUXIL_arithm_fois4;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_arithm;

if (flag_help_only){
      hproc_oparithm_mul_deuximagescomplex();
      return;
}
if (flag_help) hproc_oparithm_mul_deuximagescomplex();

AUXIL_arithm = build_IOplans_widget(AUXIL_arithm_fois4, 21, panel_titres[148], NULL);
XtManageChild(AUXIL_arithm);
}


/******************************************************
/   activateCallback for Widget  AUXIL_logic
/*****************************************************/

void
AUXIL_logic_actcall(AUXIL_logic, Comment_Area, callData)
	Widget AUXIL_logic;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) oplogic_help_proc();
}


/******************************************************
/   activateCallback for Widget  AUXIL_logic_and 
/*****************************************************/

void
AUXIL_logic_and_actcall(AUXIL_logic_and, Comment_Area, callData)
	Widget AUXIL_logic_and;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_logic;

if (flag_help_only){
      hproc_oplogic_AND();
      return;
}
if (flag_help) hproc_oplogic_AND();

AUXIL_logic = build_IOplans_widget(AUXIL_logic_and, 30, panel_titres[149], NULL);
XtManageChild(AUXIL_logic);
}


/******************************************************
/   activateCallback for Widget  AUXIL_logic_andmask 
/*****************************************************/

void
AUXIL_logic_andmask_actcall(AUXIL_logic_andmask, Comment_Area, callData)
	Widget AUXIL_logic_andmask;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_logic;

if (flag_help_only){
      hproc_oplogic_AND_BOUNDED();
      return;
}
if (flag_help) hproc_oplogic_AND_BOUNDED();

AUXIL_logic = build_IOplans_widget(AUXIL_logic_andmask, 31, panel_titres[150], NULL);
XtManageChild(AUXIL_logic);
}


/******************************************************
/   activateCallback for Widget  AUXIL_logic_or 
/*****************************************************/

void
AUXIL_logic_or_actcall(AUXIL_logic_or, Comment_Area, callData)
	Widget AUXIL_logic_or;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_logic;

if (flag_help_only){
      hproc_oplogic_OR();
      return;
}
if (flag_help) hproc_oplogic_OR();

AUXIL_logic = build_IOplans_widget(AUXIL_logic_or, 32, panel_titres[151], NULL);
XtManageChild(AUXIL_logic);
}


/******************************************************
/   activateCallback for Widget  AUXIL_logic_xor 
/*****************************************************/

void
AUXIL_logic_xor_actcall(AUXIL_logic_xor, Comment_Area, callData)
	Widget AUXIL_logic_xor;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_logic;

if (flag_help_only){
      hproc_oplogic_XOR();
      return;
}
if (flag_help) hproc_oplogic_XOR();

AUXIL_logic = build_IOplans_widget(AUXIL_logic_xor, 33, panel_titres[152], NULL);
XtManageChild(AUXIL_logic);
}


/******************************************************
/   activateCallback for Widget  AUXIL_logic_not 
/*****************************************************/

void
AUXIL_logic_not_actcall(AUXIL_logic_not, Comment_Area, callData)
	Widget AUXIL_logic_not;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_logic;

if (flag_help_only){
      hproc_oplogic_NOT();
      return;
}
if (flag_help) hproc_oplogic_NOT();

AUXIL_logic = build_IOplans_widget(AUXIL_logic_not, 34, panel_titres[153], NULL);
XtManageChild(AUXIL_logic);
}


/******************************************************
/   activateCallback for Widget  AUXILIARY_geom
/*****************************************************/

void
AUXIL_geom_actcall(AUXILIARY_geom, Comment_Area, callData)
	Widget AUXILIARY_geom;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) opgeom_help_proc();
}


/******************************************************
/   activateCallback for Widget  AUXIL_geom_rotation 
/*****************************************************/

void
AUXIL_geom_rotation_actcall(AUXIL_geom_rotation, Comment_Area, callData)
	Widget AUXIL_geom_rotation;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_geom;

if (flag_help_only){
      hproc_opgeom_rotate();
      return;
}
if (flag_help) hproc_opgeom_rotate();

AUXIL_geom = build_IOplans_widget(AUXIL_geom_rotation, 40, panel_titres[154], NULL);
XtManageChild(AUXIL_geom);
}


/******************************************************
/   activateCallback for Widget  AUXIL_geom_translation 
/*****************************************************/

void
AUXIL_geom_translation_actcall(AUXIL_geom_translation, Comment_Area, callData)
	Widget AUXIL_geom_translation;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_geom;

if (flag_help_only){
      hproc_opgeom_translate();
      return;
}
if (flag_help) hproc_opgeom_translate();

AUXIL_geom = build_IOplans_widget(AUXIL_geom_translation, 41, panel_titres[155], NULL);
XtManageChild(AUXIL_geom);
}


/******************************************************
/   activateCallback for Widget  AUXIL_geom_scalingS 
/*****************************************************/

void
AUXIL_geom_scalingS_actcall(AUXIL_geom_scalingS, Comment_Area, callData)
	Widget AUXIL_geom_scalingS;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_geom;

if (flag_help_only){
      hproc_opgeom_scaleT();
      return;
}
if (flag_help) hproc_opgeom_scaleT();

AUXIL_geom = build_IOplans_widget(AUXIL_geom_scalingS, 42, panel_titres[156], NULL);
XtManageChild(AUXIL_geom);
}


/******************************************************
/   activateCallback for Widget  AUXIL_geom_scalingF 
/*****************************************************/

void
AUXIL_geom_scalingF_actcall(AUXIL_geom_scalingF, Comment_Area, callData)
	Widget AUXIL_geom_scalingF;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_geom;

if (flag_help_only){
      hproc_opgeom_scaleF();
      return;
}
if (flag_help) hproc_opgeom_scaleF();

AUXIL_geom = build_IOplans_widget(AUXIL_geom_scalingF, 43, panel_titres[157], NULL);
XtManageChild(AUXIL_geom);
}


/******************************************************
/   activateCallback for Widget  AUXIL_geom_transposition 
/*****************************************************/

void
AUXIL_geom_transposition_actcall(AUXIL_geom_transposition, Comment_Area, callData)
	Widget AUXIL_geom_transposition;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_geom;

if (flag_help_only){
      hproc_opgeom_transpose();
      return;
}
if (flag_help) hproc_opgeom_transpose();

AUXIL_geom = build_IOplans_widget(AUXIL_geom_transposition, 44, panel_titres[158], NULL);
XtManageChild(AUXIL_geom);
}


/******************************************************
/   activateCallback for Widget  AUXIL_geom_symmetryX 
/*****************************************************/

void
AUXIL_geom_symmetryX_actcall(AUXIL_geom_symmetryX, Comment_Area, callData)
	Widget AUXIL_geom_symmetryX;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_geom;

if (flag_help_only){
      hproc_opgeom_sym_x();
      return;
}
if (flag_help) hproc_opgeom_sym_x();

AUXIL_geom = build_IOplans_widget(AUXIL_geom_symmetryX, 45, panel_titres[159], NULL);
XtManageChild(AUXIL_geom);
}


/******************************************************
/   activateCallback for Widget  AUXIL_geom_symmetryY 
/*****************************************************/

void
AUXIL_geom_symmetryY_actcall(AUXIL_geom_symmetryY, Comment_Area, callData)
	Widget AUXIL_geom_symmetryY;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_geom;

if (flag_help_only){
      hproc_opgeom_sym_y();
      return;
}
if (flag_help) hproc_opgeom_sym_y();

AUXIL_geom = build_IOplans_widget(AUXIL_geom_symmetryY, 46, panel_titres[160], NULL);
XtManageChild(AUXIL_geom);
}


/******************************************************
/   activateCallback for Widget  AUXIL_modif
/*****************************************************/

void
AUXIL_modif_actcall(AUXIL_modif, Comment_Area, callData)
	Widget AUXIL_modif;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) modif_help_proc();
}


/******************************************************
/   activateCallback for Widget  AUXIL_modif_enlarg
/*****************************************************/

void
AUXIL_modif_enlarg_actcall(AUXIL_modif, Comment_Area, callData)
	Widget AUXIL_modif;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) hproc_interpol_ordre1();
}


/******************************************************
/   activateCallback for Widget  AUXIL_modif_enlarg_1st_ord_interp 
/*****************************************************/

void
AUXIL_modif_enlarg_1st_ord_interp_actcall(AUXIL_modif_enlarg_1st_ord_interp, Comment_Area, callData)
	Widget AUXIL_modif_enlarg_1st_ord_interp;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_modif;

/*if (flag_help_only){
      hproc_interpol_ordre1();
      return;
}
if (flag_help) hproc_interpol_ordre1();
*/
AUXIL_modif = 
	build_IOplans_widget(AUXIL_modif_enlarg_1st_ord_interp, 50, panel_titres[161], NULL);
XtManageChild(AUXIL_modif);
}


/******************************************************
/   activateCallback for Widget  AUXIL_modif_padding
/*****************************************************/

void
AUXIL_modif_padding_actcall(AUXIL_modif_padding, Comment_Area, callData)
	Widget AUXIL_modif_padding;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) 
  {
    pad_help_proc();
    hproc_pad_cte();
    hproc_pad_prolong();
    hproc_pad_period();
  }
}


/******************************************************
/   activateCallback for Widget  AUXIL_modif_padding_const 
/*****************************************************/

void
AUXIL_modif_padding_const_actcall(AUXIL_modif_padding_const, Comment_Area, callData)
	Widget AUXIL_modif_padding_const;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_modif;

/*if (flag_help_only){
      hproc_pad_cte();
      return;
}
if (flag_help) hproc_pad_cte();
*/
AUXIL_modif = build_IOplans_widget(AUXIL_modif_padding_const, 51, panel_titres[162], NULL);
XtManageChild(AUXIL_modif);
}


/******************************************************
/   activateCallback for Widget  AUXIL_modif_padding_prolong 
/*****************************************************/

void
AUXIL_modif_padding_prolong_actcall(AUXIL_modif_padding_prolong, Comment_Area, callData)
	Widget AUXIL_modif_padding_prolong;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_modif;

/*if (flag_help_only){
      hproc_pad_prolong();
      return;
}
if (flag_help) hproc_pad_prolong();
*/
AUXIL_modif = build_IOplans_widget(AUXIL_modif_padding_prolong, 52, panel_titres[163], NULL);
XtManageChild(AUXIL_modif);
}


/******************************************************
/   activateCallback for Widget  AUXIL_modif_padding_period 
/*****************************************************/

void
AUXIL_modif_padding_period_actcall(AUXIL_modif_padding_period, Comment_Area, callData)
	Widget AUXIL_modif_padding_period;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_modif;

/*if (flag_help_only){
      hproc_pad_period();
      return;
}
if (flag_help) hproc_pad_period();
*/
AUXIL_modif = build_IOplans_widget(AUXIL_modif_padding_period, 53, panel_titres[164], NULL);
XtManageChild(AUXIL_modif);
}


/******************************************************
/   activateCallback for Widget  AUXIL_modif_noise
/*****************************************************/

void
AUXIL_modif_noise_actcall(AUXIL_modif_noise, Comment_Area, callData)
	Widget AUXIL_modif_noise;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) 
  {
    bruit_help_proc();
    hproc_bruit_unif();
    hproc_bruit_gauss();
  }
}


/******************************************************
/   activateCallback for Widget  AUXIL_modif_noise_unif 
/*****************************************************/

void
AUXIL_modif_noise_unif_actcall(AUXIL_modif_noise_unif, Comment_Area, callData)
	Widget AUXIL_modif_noise_unif;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_modif;

/*if (flag_help_only){
      hproc_bruit_unif();
      return;
}
if (flag_help) hproc_bruit_unif();
*/
AUXIL_modif = build_IOplans_widget(AUXIL_modif_noise_unif, 54, panel_titres[165], NULL);
XtManageChild(AUXIL_modif);
}


/******************************************************
/   activateCallback for Widget  AUXIL_modif_noise_gauss 
/*****************************************************/

void
AUXIL_modif_noise_gauss_actcall(AUXIL_modif_noise_gauss, Comment_Area, callData)
	Widget AUXIL_modif_noise_gauss;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_modif;

/*if (flag_help_only){
      hproc_bruit_gauss();
      return;
}
if (flag_help) hproc_bruit_gauss();
*/
AUXIL_modif = build_IOplans_widget(AUXIL_modif_noise_gauss, 55, panel_titres[166], NULL);
XtManageChild(AUXIL_modif);
}


/******************************************************
/   activateCallback for Widget  AUXIL_modif_cut 
/*****************************************************/

void
AUXIL_modif_cut_actcall(AUXIL_modif_cut, Comment_Area, callData)
	Widget AUXIL_modif_cut;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_modif;

if (flag_help_only){
      hproc_decoupages();
      return;
}
if (flag_help) hproc_decoupages();

AUXIL_modif = build_IOplans_widget(AUXIL_modif_cut, 56, panel_titres[167], NULL);
XtManageChild(AUXIL_modif);
}



/******************************************************
/   activateCallback for Widget  AUXIL_gener_image
/*****************************************************/

void
AUXIL_gener_image_actcall(AUXIL_gener_image, Comment_Area, callData)
	Widget AUXIL_gener_image;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) imagetest_help_proc();
}


/******************************************************
/   activateCallback for Widget  AUXIL_gener_band_image
/*****************************************************/

void
AUXIL_gener_band_image_actcall(AUXIL_gener_band_image, Comment_Area, callData)
	Widget AUXIL_gener_band_image;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) 
  {
    bandim_help_proc();
    hproc_imagebandes_8();
    hproc_imagebandes_16();
    hproc_imagebandes_32();
    hproc_imagebandes_64();
  }
}


/******************************************************
/   activateCallback for Widget  AUXIL_gener_band_image_8 
/*****************************************************/

void
AUXIL_gener_band_image_8_actcall(AUXIL_gener_band_image_8, Comment_Area, callData)
	Widget AUXIL_gener_band_image_8;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_gener;

/*if (flag_help_only){
      hproc_imagebandes_8();
      return;
}
if (flag_help)hproc_imagebandes_8(); 
*/
AUXIL_gener = build_IOplans_widget(AUXIL_gener_band_image_8, 60, panel_titres[168], NULL);
XtManageChild(AUXIL_gener);
}


/******************************************************
/   activateCallback for Widget  AUXIL_gener_band_image_16 
/*****************************************************/

void
AUXIL_gener_band_image_16_actcall(AUXIL_gener_band_image_16, Comment_Area, callData)
	Widget AUXIL_gener_band_image_16;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_gener;

/*if (flag_help_only){
      hproc_imagebandes_16();
      return;
}
if (flag_help) hproc_imagebandes_16();
*/
AUXIL_gener = build_IOplans_widget(AUXIL_gener_band_image_16, 61, panel_titres[169], NULL);
XtManageChild(AUXIL_gener);
}


/******************************************************
/   activateCallback for Widget  AUXIL_gener_band_image_32 
/*****************************************************/

void
AUXIL_gener_band_image_32_actcall(AUXIL_gener_band_image_32, Comment_Area, callData)
	Widget AUXIL_gener_band_image_32;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_gener;

/*if (flag_help_only){
      hproc_imagebandes_32();
      return;
}
if (flag_help) hproc_imagebandes_32();
*/
AUXIL_gener = build_IOplans_widget(AUXIL_gener_band_image_32, 62, panel_titres[170], NULL);
XtManageChild(AUXIL_gener);
}


/******************************************************
/   activateCallback for Widget  AUXIL_gener_band_image_64 
/*****************************************************/

void
AUXIL_gener_band_image_64_actcall(AUXIL_gener_band_image_64, Comment_Area, callData)
	Widget AUXIL_gener_band_image_64;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_gener;

/*if (flag_help_only){
      hproc_imagebandes_64();
      return;
}
if (flag_help) hproc_imagebandes_64();
*/
AUXIL_gener = build_IOplans_widget(AUXIL_gener_band_image_64, 63, panel_titres[171], NULL);
XtManageChild(AUXIL_gener);
}


/******************************************************
/   activateCallback for Widget  AUXIL_gener_monochrome 
/*****************************************************/

void
AUXIL_gener_monochrome_actcall(AUXIL_gener_monochrome, Comment_Area, callData)
	Widget AUXIL_gener_monochrome;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_gener;

if (flag_help_only){
      hproc_gen_pts_controle_mono();
      return;
}
if (flag_help) hproc_gen_pts_controle_mono();

AUXIL_gener = Build_image_generation(0);
XtManageChild(AUXIL_gener);
}


/******************************************************
/   activateCallback for Widget  AUXIL_gener_gray_tone 
/*****************************************************/

void
AUXIL_gener_gray_tone_actcall(AUXIL_gener_gray_tone, Comment_Area, callData)
	Widget AUXIL_gener_gray_tone;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_gener;

if (flag_help_only){
      hproc_gen_pts_controle_couleur();
      return;
}
if (flag_help) hproc_gen_pts_controle_couleur();

AUXIL_gener = Build_image_generation(1);
XtManageChild(AUXIL_gener);
}


/******************************************************
/   activateCallback for Widget  AUXIL_desctool 
/*****************************************************/

void
AUXIL_desctool_actcall(AUXIL_desctool, Comment_Area, callData)
	Widget AUXIL_desctool;
	Widget Comment_Area;
	caddr_t callData;
{

if (flag_help_only){
      hproc_desctool();
      return;
}
if (flag_help) hproc_desctool();
    
sprintf (buf, mastertabs[121]);
write_master (buf);

Build_desctool();
}


/******************************************************
/   activateCallback for Widget  AUXIL_free
/*****************************************************/

void
AUXIL_free_actcall(AUXIL_free, Comment_Area, callData)
	Widget AUXIL_free;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) libere_help_proc();
}


/******************************************************
/   activateCallback for Widget  AUXIL_free_all_planes 
/*****************************************************/

void
AUXIL_free_all_planes_actcall(AUXIL_free_all_planes, Comment_Area, callData)
	Widget AUXIL_free_all_planes;
	Widget Comment_Area;
	caddr_t callData;
{

if (flag_help_only){
      hproc_libere_tousplans();
      return;
}
if (flag_help) hproc_libere_tousplans();

	proc_libere (0);
}


/******************************************************
/   activateCallback for Widget  AUXIL_free_single_plane 
/*****************************************************/

void
AUXIL_free_single_plane_actcall(AUXIL_free_single_plane, Comment_Area, callData)
	Widget AUXIL_free_single_plane;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_free_single_plane_widget;
	
if (flag_help_only){
      hproc_libere_unplan();
      return;
}
if (flag_help) hproc_libere_unplan();

AUXIL_free_single_plane_widget = 
	build_DISPLAY_show_image_widget(AUXIL_free_single_plane, 1, 7, panel_titres[176]);
XtManageChild(AUXIL_free_single_plane_widget);

}


/******************************************************
/   activateCallback for Widget  AUXIL_free_all_vectors 
/*****************************************************/

void
AUXIL_free_all_vectors_actcall(AUXIL_free_all_vectors, Comment_Area, callData)
	Widget AUXIL_free_all_vectors;
	Widget Comment_Area;
	caddr_t callData;
{

if (flag_help_only){
      hproc_libere_tousvects();
      return;
}
if (flag_help) hproc_libere_tousvects();

	proc_libere (2);
}


/******************************************************
/   activateCallback for Widget  AUXIL_free_single_vector 
/*****************************************************/

void
AUXIL_free_single_vector_actcall(AUXIL_free_single_vector, Comment_Area, callData)
	Widget AUXIL_free_single_vector;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_free_single_vector_widget;
	
if (flag_help_only){
      hproc_libere_unvect();
      return;
}
if (flag_help) hproc_libere_unvect();

AUXIL_free_single_vector_widget = 
	build_DISPLAY_show_image_widget(AUXIL_free_single_vector, 1, 8, panel_titres[178]);
XtManageChild(AUXIL_free_single_vector_widget);

}


/******************************************************
/   activateCallback for Widget  AUXIL_copy_plane 
/*****************************************************/

void
AUXIL_copy_plane_actcall(AUXIL_copy_plane, Comment_Area, callData)
	Widget AUXIL_copy_plane;
	Widget Comment_Area;
	caddr_t callData;
{
Widget AUXIL_copy;

if (flag_help_only){
      hproc_copie_plan();
      return;
}
if (flag_help) hproc_copie_plan();

AUXIL_copy = build_IOplans_widget(AUXIL_copy_plane, 70, panel_titres[179], NULL);
XtManageChild(AUXIL_copy);
}


/******************************************************
/   activateCallback for Widget  TOOLS
/*****************************************************/

void
TOOLS_actcall(TOOLS, Comment_Area, callData)
	Widget TOOLS;
        Widget Comment_Area;
	caddr_t callData;
{
if (flag_help_only || flag_help) tools_help_proc();
}


/******************************************************
/   activateCallback for Widget  TOOLS_expert_enhancement 
/*****************************************************/

void
TOOLS_expert_enhancement_actcall(TOOLS_expert_enhancement, Comment_Area, callData)
	Widget TOOLS_expert_enhancement;
	Widget Comment_Area;
	caddr_t callData;
{
	/* ADD CALLBACK CODE HERE */
}


/******************************************************
/   activateCallback for Widget  TOOLS_expert_contour 
/*****************************************************/

void
TOOLS_expert_contour_actcall(TOOLS_expert_contour, Comment_Area, callData)
	Widget TOOLS_expert_contour;
	Widget Comment_Area;
	caddr_t callData;
{
	/* ADD CALLBACK CODE HERE */
}


/******************************************************
/   activateCallback for Widget  TOOLS_expert_threshold 
/*****************************************************/

void
TOOLS_expert_threshold_actcall(TOOLS_expert_threshold, Comment_Area, callData)
	Widget TOOLS_expert_threshold;
	Widget Comment_Area;
	caddr_t callData;
{
	/* ADD CALLBACK CODE HERE */
}


/******************************************************
/   activateCallback for Widget  TOOLS_expert_count_elem 
/*****************************************************/

void
TOOLS_expert_count_elem_actcall(TOOLS_expert_count_elem, Comment_Area, callData)
	Widget TOOLS_expert_count_elem;
	Widget Comment_Area;
	caddr_t callData;
{
	/* ADD CALLBACK CODE HERE */
}


/******************************************************
/   activateCallback for Widget  TOOLS_expert_classify 
/*****************************************************/

void
TOOLS_expert_classify_actcall(TOOLS_expert_classify, Comment_Area, callData)
	Widget TOOLS_expert_classify;
	Widget Comment_Area;
	caddr_t callData;
{
	/* ADD CALLBACK CODE HERE */
}


/******************************************************
/   activateCallback for Widget  TOOLS_gel1D 
/*****************************************************/

void
TOOLS_gel1D_actcall(TOOLS_gel1D, Comment_Area, callData)
	Widget TOOLS_gel1D;
	Widget Comment_Area;
	caddr_t callData;
{
  if (flag_help_only){
	 hproc_gel1dTool();
	 return;
  }
  if (flag_help) hproc_gel1dTool();  
  proc_entree_gel1d ();
  XtManageChild(Menu_Gel1D);
  XtManageChild(QUIT_Gel1D);
}











