/* SCCS @(#)meapowcfr.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       meapowcfr.layout.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   meapowcfr.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Measures Power Cut Frequency                        */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "meapowcfr.layout.h"
#include <math.h>

#define MAX_ARGS 100
#define MIN(A,B)    ((A)<(B)?(A):(B))

extern XmFontList gFontlist, gSmall_fontlist;


static void 
param_SET_callb (options_OK, Paramprepro, callData)
     Widget options_OK;
     xs_struc_paramprepro *Paramprepro;
     caddr_t callData;
{
  char stitre[30];
  int radius;
  
  radius = (int) ((MIN(dir_desc[index_image[0]].nligne, dir_desc[index_image[0]].ncolonne) + 1)/10);

  sprintf (stitre, "%d", radius); 
  XmTextSetString (Paramprepro->alpha, stitre);
}


/********************************************************
/   Creation Function for MEAS_power_param_widget 
/*******************************************************/

xs_struc_paramprepro
* build_MEAS_cut_freq_param_widget(meapowcfr)
	Widget meapowcfr;
{
	Widget MEAS_power_param_widget;
	Widget param_SET;
	Widget MEAS_power_text;
	Widget MEAS_power_Label;
	Widget labelmin;
	Widget Labelmax;
	xs_struc_paramprepro *Paramprepro;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating MEAS_power_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,200); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,194); n++;
	XtSetArg(args[n],XmNx,7); n++;
	XtSetArg(args[n],XmNy,5); n++;

	MEAS_power_param_widget = 
	    XmCreateForm(meapowcfr,"MEAS_power_param_widget",args,n);

	Paramprepro->parent = MEAS_power_param_widget;

	/* Creating param_SET Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNbottomPosition,96); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[106],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 20); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 80); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 84); n++;


	param_SET = XmCreatePushButton(MEAS_power_param_widget, 
				       "param_SET",args,n);

	XtManageChild(param_SET);

	/* Adding Callbacks for param_SET */ 

	XtAddCallback(param_SET,XmNactivateCallback,
		      param_SET_callb, Paramprepro);


	/* Creating MEAS_power_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,18); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,50); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	MEAS_power_text = 
	  XmCreateText(MEAS_power_param_widget,"MEAS_power_text",args,n);
	XtManageChild(MEAS_power_text);

	Paramprepro->alpha = MEAS_power_text;

	/* Creating MEAS_power_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[487],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,35); n++;

	MEAS_power_Label = 
	   XmCreateLabel(MEAS_power_param_widget,"MEAS_power_Label",args,n);
	XtManageChild(MEAS_power_Label);

	/* Creating labelmin Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0 < ",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNrightWidget,MEAS_power_text); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;

	labelmin = XmCreateLabel(MEAS_power_param_widget,"labelmin",args,n);
	XtManageChild(labelmin);

	/* Creating Labelmax Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(" < (size img)/2",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,MEAS_power_text); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;

	Labelmax = XmCreateLabel(MEAS_power_param_widget,"Labelmax",args,n);
	XtManageChild(Labelmax);

	return(Paramprepro);
}
