/* SCCS @(#)morpho.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       morpho.layout.c                                */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   morpho.layout.c                                     */
/*                                                                      */
/* DESCRIPTION  :   Binary Morphology parameters                        */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "morpho.layout.h"

#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;
extern Pixel      gorchid;
extern int        angle;

/********************************************************
/   Creation Function for MORPHO_param_widget 
/*******************************************************/

xs_struc_paramprepro
* build_MORPHO_param_widget(morpho, nbr_param)
	Widget morpho;
	int    nbr_param;      /* 1: taille        2: taille + angle */
{
	Widget MORPHO_param_widget;
	Widget Size_label;
	Widget Max_label;
	Widget Min_label;
	Widget Angle_label;
	Widget Angles_RowColumn;
	Widget Plane[6];
	plan_image_select *Tableau_plans;
	xs_struc_paramprepro *Paramprepro;
	Widget taille_text;
	char num[4];
	Arg args[MAX_ARGS];
	int i, j, n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating MORPHO_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,217); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,209); n++;
	XtSetArg(args[n],XmNx,14); n++;
	XtSetArg(args[n],XmNy,26); n++;

	MORPHO_param_widget = XmCreateForm(morpho,"MORPHO_param_widget",args,n);
	XtManageChild(MORPHO_param_widget);

	Paramprepro->parent = MORPHO_param_widget;

	/* Creating Size_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[211],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,5); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,15); n++;

	Size_label = XmCreateLabel(MORPHO_param_widget,"Size_label",args,n);
	XtManageChild(Size_label);

	/* Creating Max_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("< 20",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,55); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,32); n++;

	Max_label = XmCreateLabel(MORPHO_param_widget,"Max_label",args,n);
	XtManageChild(Max_label);

	/* Creating Min_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("-1 <",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,20); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,32); n++;

	Min_label = XmCreateLabel(MORPHO_param_widget,"Min_label",args,n);
	XtManageChild(Min_label);

       if (nbr_param == 2){

	  /* Creating Angle_label Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[196],
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition, 5); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,60); n++;

	  Angle_label = XmCreateLabel(MORPHO_param_widget,"Angle_label",args,n);
	  XtManageChild(Angle_label);

	  /* Creating Angles_RowColumn Widget */ 

	  n = 0;
	  XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNleftPosition, 10); n++;
	  XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	  XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	  XtSetArg(args[n],XmNtopPosition,70); n++;

	  Angles_RowColumn = 
		XmCreateRowColumn(MORPHO_param_widget,"Angles_RowColumn",args,n);
	  XtManageChild(Angles_RowColumn);

	  /* Creating Plane[6] Widgets */ 
	  Tableau_plans = 
	      (plan_image_select *) malloc (sizeof (plan_image_select));

	  for (i=0;i < 6; i++){	
	    j = i*60;
	    itoa (j, num);
	    n = 0;
	    XtSetArg(args[n],XmNfontList, gFontlist); n++;
	    XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	    XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	    XtSetArg(args[n],XmNrecomputeSize,false); n++;

	    XtSetArg (args[n],XmNbackground, 
		ColorNameToPixel (Angles_RowColumn,"thistle"));n++;  
    
	    Plane[i] = XmCreateDrawnButton(Angles_RowColumn,"Plane",args,n);

	    XtManageChild(Plane[i]);

	    Tableau_plans->plan_image[i] = Plane[i];
	  }

	    /* Adding Callbacks for Plane[i] */ 

	  for (i=0;i < 6; i++)
	    XtAddCallback(Plane[i],
		XmNactivateCallback, angle_selected,Tableau_plans);

	  /* Initialization of the global parameter angle */
	  n = 0;
	  XtSetArg (args[n],XmNbackground, gorchid); n++;
	  XtSetValues (Plane[0], args, n);
	  angle = 0;


	} /*if (nbr_param == 2)*/

	  /* Creating taille_text Widget */ 

 	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,Min_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,53); n++;
	XtSetArg(args[n],XmNrightWidget,Max_label); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,32); n++;
	XtSetArg(args[n],XmNvalue, "1"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	taille_text = XmCreateText(MORPHO_param_widget,"taille_text",args,n);
	XtManageChild(taille_text);

	Paramprepro->alpha = taille_text;

	return(Paramprepro);
}
