/* SCCS @(#)select2planeO.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                        select2planeO.layout.c                        */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   select2planeO.layout.c                              */
/*                                                                      */
/* DESCRIPTION  :   2 Output planes                                     */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "select2planeO.layout.h"
#include "widgetstructure.h"

#define MAX_ARGS 100

extern XmFontList gFontlist;
extern Pixel      gorchid, gthistle;

/********************************************************
/   Creation Function for Selection2Planesout 
/*******************************************************/

Widget
build_Selection2Planesout(select2planeoutput, IO_load_image_planeout_OK, message1, message2)
	Widget select2planeoutput;
	Widget IO_load_image_planeout_OK;
        char *message1;
        char *message2;
{
	Widget Selection2Planesout;
	Widget Select2Plane0;
	Widget Select2Plane1;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Selection2Planesout Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx,1); n++;

	Selection2Planesout = 
	   XmCreateRowColumn(select2planeoutput,"Selection2Planesout",args,n);
	XtManageChild(Selection2Planesout);

	/* Creating Select2Plane0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[100],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Select2Plane0 = 
	    XmCreateLabel(Selection2Planesout,"Select2Plane0",args,n);
	XtManageChild(Select2Plane0);

	/* Creating Select2Plane1 Widget */ 

	Select2Plane1 = 
	  build_Select2Plane1bis(Selection2Planesout, 
		IO_load_image_planeout_OK, message1, message2);

	return(Selection2Planesout);
}


/********************************************************
/   Creation Function for Select2Plane1 
/*******************************************************/

Widget
build_Select2Plane1bis(Selection2Planesout, IO_load_image_planeout_OK, message1, message2)
	Widget Selection2Planesout;
	Widget IO_load_image_planeout_OK;
        char *message1;
        char *message2;
{
	Widget Select2Plane1;
	Widget Select2PlaneLabel1;
	Widget SelectPlanesR;
	Widget SelectPlanesI;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Select2Plane1 Widget */ 


	Select2Plane1 = 
	    XmCreateRowColumn(Selection2Planesout,"Select2Plane1",NULL,0);
	XtManageChild(Select2Plane1);

	/* Creating Select2PlaneLabel1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[102],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Select2PlaneLabel1 = 
	    XmCreateLabel(Select2Plane1,"Select2PlaneLabel1",args,n);
	XtManageChild(Select2PlaneLabel1);

	/* Creating SelectPlanesR Widget */ 

	SelectPlanesR = 
	    build_SelectPlanesR(Select2Plane1, 
				IO_load_image_planeout_OK, message1, 1);

	/* Creating SelectPlanesI Widget */ 

	SelectPlanesI = 
	    build_SelectPlanesIbis(Select2Plane1, 
				   IO_load_image_planeout_OK, message2, 2);

	return(Select2Plane1);
}


/********************************************************
/   Creation Function for SelectPlanesR 
/*******************************************************/

Widget
build_SelectPlanesR(Select2Plane1, IO_load_image_planeout_OK, message, numplan)
	Widget Select2Plane1;
	Widget IO_load_image_planeout_OK;
        char *message;
 	int numplan;
{
	Widget SelectPlanesR;
	Widget SelectPlaneRLabel2;
	Widget PlaneRnumbers;
	Widget Planeout[MAX_IMAGE];
	plan_image_select *Tableau_plans;
	char num[4];
	Arg args[MAX_ARGS];
	int i, n;

	/* Creating SelectPlanesR Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	SelectPlanesR = 
	    XmCreateRowColumn(Select2Plane1,"SelectPlanesR",args,n);
	XtManageChild(SelectPlanesR);

	/* Creating SelectPlaneRLabel2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
			XmSTRING_DEFAULT_CHARSET)); n++;

	SelectPlaneRLabel2 =
	    XmCreateLabel(SelectPlanesR,"SelectPlaneRLabel2",args,n);
	XtManageChild(SelectPlaneRLabel2);

	/* Creating PlaneRnumbers Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	PlaneRnumbers = XmCreateForm(SelectPlanesR,"PlaneRnumbers",args,n);
	XtManageChild(PlaneRnumbers);

	/* Creating Planeout[MAX_IMAGE] Widgets */ 
	Tableau_plans = 
	    (plan_image_select *) malloc (sizeof (plan_image_select));

	for (i=0;i < MAX_IMAGE; i++){
	  itoa (i, num);	 
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	  else
	  {
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	    XtSetArg(args[n],XmNleftWidget,Planeout[i-1]);
	  }
	  n++;
	  XtSetArg(args[n],XmNwidth, 20); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	  XtSetArg(args[n],XmNrecomputeSize,false); n++;
	  XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	  /* Definition de l'occupation du plan represente par ce bouton!*/
	  if (Occupation_Plan(i) == 1){
	    XtSetArg (args[n],XmNforeground, gorchid); n++;
	  }
	  XtSetArg (args[n],XmNbackground, gthistle);n++;

	  Planeout[i] = XmCreateDrawnButton(PlaneRnumbers,"Planeout",args,n);
	  XtManageChild(Planeout[i]);


	  Tableau_plans->plan_image[i] = Planeout[i];
	}

	Tableau_plans->num_index = numplan;

	  /* Adding Callbacks for Planeout[i] */ 

	for (i=0;i < MAX_IMAGE; i++)
	  XtAddCallback(Planeout[i],
		XmNactivateCallback, planeout_selected,Tableau_plans);

	XtAddCallback(IO_load_image_planeout_OK,XmNactivateCallback,
		      libere_memoire,Tableau_plans);


	return(SelectPlanesR);
}


/********************************************************
/   Creation Function for SelectPlanesI 
/*******************************************************/

Widget
build_SelectPlanesIbis(Select2Plane1, IO_load_image_planeout_OK, message, numplan)
	Widget Select2Plane1;
	Widget IO_load_image_planeout_OK;
        char *message;
	int numplan;
{
	Widget SelectPlanesI;
	Widget SelectPlaneILabel2;
	Widget PlaneInumbers;
	Widget Planeout[MAX_IMAGE];
	plan_image_select *Tableau_plans;
	char num[4];
	Arg args[MAX_ARGS];
	int i, n;

	/* Creating SelectPlanesI Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	SelectPlanesI = 
		XmCreateRowColumn(Select2Plane1,"SelectPlanesI",args,n);
	XtManageChild(SelectPlanesI);

	/* Creating SelectPlaneILabel2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
			XmSTRING_DEFAULT_CHARSET)); n++;

	SelectPlaneILabel2 = 
		XmCreateLabel(SelectPlanesI,"SelectPlaneILabel2",args,n);
	XtManageChild(SelectPlaneILabel2);

	/* Creating PlaneInumbers Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	PlaneInumbers = XmCreateForm(SelectPlanesI,"PlaneInumbers",args,n);

	XtManageChild(PlaneInumbers);

	/* Creating Planeout[MAX_IMAGE] Widgets */ 
	Tableau_plans = 
	    (plan_image_select *) malloc (sizeof (plan_image_select));

	for (i=0;i < MAX_IMAGE; i++){
	  itoa (i, num);	 
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	  else
	  {
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	    XtSetArg(args[n],XmNleftWidget,Planeout[i-1]);
	  }
	  n++;
	  XtSetArg(args[n],XmNwidth, 20); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	  XtSetArg(args[n],XmNrecomputeSize,false); n++;
	  XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	  /* Definition de l'occupation du plan represente par ce bouton!*/
	  if (Occupation_Plan(i) == 1){
	    XtSetArg (args[n],XmNforeground, gorchid); n++;
	  }
	  XtSetArg (args[n],XmNbackground, gthistle);n++;

	  Planeout[i] = XmCreateDrawnButton(PlaneInumbers,"Planeout",args,n);
	  XtManageChild(Planeout[i]);
	  
	  Tableau_plans->plan_image[i] = Planeout[i];
	}

	Tableau_plans->num_index = numplan;

	  /* Adding Callbacks for Planeout[i] */ 

	for (i=0;i < MAX_IMAGE; i++)
	  XtAddCallback(Planeout[i],
		XmNactivateCallback, planeout_selected,Tableau_plans);

	XtAddCallback(IO_load_image_planeout_OK,XmNactivateCallback,
		      libere_memoire,Tableau_plans);


	return(SelectPlanesI);
}
