/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * sgi.c - interface with SGI format ( needs SGI libraries ).
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Sat Feb 22 1992
 * Copyright (c) 1992, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>


/*
 * Look here !!!
 * =============
 *
 * This code is valid only if we have defined the iSGI
 * macro ( read the root Makefile for more information ).
 *
 */

#ifdef iSGI

#include <image.h>

extern int LUGverbose;

read_sgi_file( name, bitmap )
char *name;
bitmap_hdr *bitmap;
{
  register int i, j;
  IMAGE *sgi_image;
  byte *r, *g, *b;
  short *sgibuf;
  int totalsize;
  int flag24;

  VPRINTF(stderr, "Reading SGI image\n");

  if ( (sgi_image = iopen( name, "rb" )) == NULL )
    error( 1 );
  /* if ( sgi_image->zsize < 3 )
      error( 7 ); */

  /*
   * Fill our header.
   */
  bitmap->magic = LUGUSED;
  bitmap->xsize = sgi_image->xsize;
  bitmap->ysize = sgi_image->ysize;
  bitmap->depth = 8 * sgi_image->zsize;
  bitmap->colors = ( 1 << bitmap->depth );
  flag24 = (bitmap->depth > 8);

  totalsize = bitmap->xsize * bitmap->ysize;
  r = bitmap->r = (byte *) Malloc( totalsize );
  if ( flag24 ) {
    g = bitmap->g = (byte *) Malloc( totalsize );
    b = bitmap->b = (byte *) Malloc( totalsize );
  }else bitmap->cmap = (byte *) create_bw_pallete();

  /*
   * Allocate memory for sgi raster line.
   */
  sgibuf = (short *) Malloc( sizeof(short) * bitmap->xsize );

  for ( i = 0; i < bitmap->ysize; i++ ) {
    j = bitmap->ysize - 1 - i;
    getrow( sgi_image, sgibuf, j, 0 );
    (void) shorttobyte( sgibuf, r, bitmap->xsize );
    r += bitmap->xsize;
    if ( flag24 ) {
      getrow( sgi_image, sgibuf, j, 1 );
      (void) shorttobyte( sgibuf, g, bitmap->xsize );
      g += bitmap->xsize;
      getrow( sgi_image, sgibuf, j, 2 );
      (void) shorttobyte( sgibuf, b, bitmap->xsize );
      b += bitmap->xsize;
    }
  }

  iclose( sgi_image );
  free( sgibuf );
}

write_sgi_file( name, bitmap )
char *name;
bitmap_hdr *bitmap;
{
  register int i;
  byte *r, *g, *b;
  IMAGE *sgi_image;
  short *buffer;

  if ( bitmap->magic != LUGUSED )
    error( 19 );

  if ( bitmap->depth < 24 )
    error( 7 );

  VPRINTF(stderr, "Writing SGI image\n");

  /* Open the SGI file */
  sgi_image = iopen( name, "wb", RLE(1), 3, bitmap->xsize, bitmap->ysize, 3 );

  /* Set pointers */
  r = bitmap->r;
  g = bitmap->g;
  b = bitmap->b;

  /*
   * SGI format uses shorts instead of bytes, so we need convert our
   * lines to this format ( and need memory ).
   */
  buffer = (short *) Malloc( sizeof(short) * bitmap->xsize );

  for ( i = 0; i < bitmap->ysize; i++ ) {
    /*
     * Write each line ( before convert it to shorts ).
     */
    putrow( sgi_image, bytetoshort( r, buffer, bitmap->xsize ),
            bitmap->ysize - 1 - i, 0 );
    putrow( sgi_image, bytetoshort( g, buffer, bitmap->xsize ),
            bitmap->ysize - 1 - i, 1 );
    putrow( sgi_image, bytetoshort( b, buffer, bitmap->xsize ),
            bitmap->ysize - 1 - i, 2 );

    /* Move pointers */
    r += bitmap->xsize;
    g += bitmap->xsize;
    b += bitmap->xsize;
  }

  /* Close the SGI file and free buffer */
  iclose( sgi_image );
  free( buffer );
}


#endif  /* iSGI */
