/*
 * hf2gif.c
 *
 * (c) 1993, Raul Rivero
 *
 * Too easy, so no extra comments :-).
 */

#include <lug.h>
#include <lugfnts.h>

main( argc, argv )
int argc;
char **argv;
{
  bitmap_hdr bitmap;
  FILE *handle;
  float *input_buffer;
  byte *ptr;
  int file_size;

  if ( argc < 3 ) {
    fprintf( stderr, "Usage: %s <float_file> <out_file_format>\n");
    exit( 1 );
  }

  /* 
   * Open, read and close the input file.
   */
  handle = Fopen( argv[1], "rb" );
  input_buffer = (float *) read_file( handle, &file_size );
  Fclose( handle );

  /*
   * It's a hf file so we supose a [0..1] scale,
   * skip the first four bytes ( the dimension ) and
   * transalete the rest.
   */
  bcopy( input_buffer, &(bitmap.xsize), sizeof(int) );
  bitmap.ysize = bitmap.xsize;
  fprintf( stderr,"converting a %dx%d pixels heightfield\n", 
           bitmap.xsize, bitmap.ysize );
  ptr = (byte *) input_buffer;
  bitmap.r = floattobyte( (float*)(ptr+sizeof(int)), NULL, 
                          bitmap.xsize*bitmap.ysize );

  /*
   * Fill the other bitmap's fields.
   */
  bitmap.depth = 8;
  bitmap.colors = ( 1 << bitmap.depth );
  bitmap.cmap =  create_bw_pallete();
  bitmap.magic = LUGUSED;

  /*
   * Ok, write it!.
   */
  write_gif_file( argv[2], &bitmap );

  /*
   * Bye!.
   */
  exit( 0 );  
}
