
/*
    GLE Extrusion, Sweep and Tubing Library Version 2.1
    Copyright (C) 1991, 1993, 1995 Linas Vepstas (linas@fc.net)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Contact linas by writing to linas@fc.net or
    Linas Vepstas
    1518 Enfield Road
    Austin TX 78703-3424
*/

/*
 * MODULE: segment.h
 *
 * Contains function prototypes for segment drawing subroutines.
 */

/* ============================================================ */

extern void draw_segment_plain (int ncp,       /* number of contour points */
                           gleDouble front_contour[][3],
                           gleDouble back_contour[][3]);

extern void draw_segment_color (int ncp,       /* number of contour points */
                           gleDouble front_contour[][3],
                           gleDouble back_contour[][3],
                           float color_last[3],
                           float color_next[3]);

extern void draw_segment_edge_n (int ncp,      /* number of contour points */
                           gleDouble front_contour[][3],
                           gleDouble back_contour[][3],
                           double norm_cont[][3]);

extern void draw_segment_c_and_edge_n (int ncp,   
                           gleDouble front_contour[][3],
                           gleDouble back_contour[][3],
                           double norm_cont[][3],
                           float color_last[3],
                           float color_next[3]);

extern void draw_segment_facet_n (int ncp,     
                           gleDouble front_contour[][3],
                           gleDouble back_contour[][3],
                           double norm_cont[][3]);

extern void draw_segment_c_and_facet_n (int ncp,    
                           gleDouble front_contour[][3],
                           gleDouble back_contour[][3],
                           double norm_cont[][3],
                           float color_last[3],
                           float color_next[3]);

/* ============================================================ */

extern void draw_binorm_segment_edge_n (int ncp,  
                           double front_contour[][3],
                           double back_contour[][3],
                           double front_norm[][3],
                           double back_norm[][3]);

extern void draw_binorm_segment_c_and_edge_n (int ncp,   
                           double front_contour[][3],
                           double back_contour[][3],
                           double front_norm[][3],
                           double back_norm[][3],
                           float color_last[3],
                           float color_next[3]);

extern void draw_binorm_segment_facet_n (int ncp, 
                           double front_contour[][3],
                           double back_contour[][3],
                           double front_norm[][3],
                           double back_norm[][3]);

extern void draw_binorm_segment_c_and_facet_n (int ncp,    
                           double front_contour[][3],
                           double back_contour[][3],
                           double front_norm[][3],
                           double back_norm[][3],
                           float color_last[3],
                           float color_next[3]);


/* -------------------------- end of file -------------------------------- */
