/*
 *  pgmtohf is a program to convert pgm (pbmplus gray scale) files to hf
 *          (rayshade height field) format.
 *
 *          It was written by Mark Dyer (markd@tdd.sj.nec.com)
 *
 *          It works for Mark on a sun sparcstation, but it's never been
 *          tested anywhere else. It's a pretty simple minded program, so I
 *          don't think there'll be much trouble compiling it on other
 *          machines.
 *
 *          Enjoy.
 */
#include <pgm.h>
#include <fcntl.h>
#include <stdio.h>

FILE *out_fp = stdout;
FILE *in_fp  = stdin;

gray** image = NULL;

main(argc, argv)
     int argc;
     char *argv[];
{
   char *infile = NULL;
   int colsP, rowsP, formatP;
   gray maxvalP;
   int hf_size = 0;
   int r = 0, c = 0;
   int out_fd = -1;
   float **data = NULL;

   pgm_init(&argc, argv);

   if(argc < 2) {
      fprintf(stderr,"Usage: %s infile [outfile]\n", argv[0]);
      exit(1);
   }
   infile = argv[1];

   in_fp = fopen (infile, "r");
   if(in_fp == NULL) {
      fprintf(stderr, "could't open %s to read.\n", infile);
      exit(1);
   }
   if(argc > 2) {
      out_fd = open(argv[2], O_WRONLY|O_CREAT|O_TRUNC, 0644);
      if(out_fd == -1) {
	 char msg[256];
	 sprintf(msg, "Can't open %s for output!\n",argv[2]);
	 perror(msg);
	 exit(1);
      }
   }
   image = pgm_readpgm (in_fp, &colsP, &rowsP, &maxvalP, &formatP);

   if(image == NULL) {
      fprintf(stderr, "pgm_readpgm failed for %s\n", infile);
      exit (1);
   }

   /*
    * Write out the hf file. 
    */
   hf_size = max(colsP, rowsP);
   data = (float**)malloc(hf_size * sizeof(float*));

   for (r = 0; r < hf_size; r++) {
      data[r] = (float*)malloc(hf_size * sizeof(float));
      for(c = 0; c < hf_size; c++) data[r][c] = -1000.0;
   }

   for (r = 0; r < hf_size; r++) {
      for (c = 0; c < hf_size; c++) {
	 if (c < colsP && r < rowsP) {
	    data[r][c] = (float)(image[r][c]) / (float)(PGM_MAXMAXVAL);
	 }
      }
   }

   write (out_fd, &hf_size, sizeof(int));
   for (r = 0; r < hf_size; r++) {
      write (out_fd, data[r], sizeof(float) * hf_size);
   }

   exit(0);
}
