/*
 * surface.h
 * $Log:	surface.h,v $
 * Revision 4.0  91/07/17  14:41:02  kolb
 * Initial version.
 */
#ifndef SURFACE_H
#define SURFACE_H
 
#define DEFAULT_INDEX		1.0	/* Default index of refraction */
#define DEFAULT_PHONGPOW	15.0	/* Default specular highlight exp */
 
/*
 * Surface definition.
 */
typedef struct Surface {
	char	*name;			/* Name */
	struct Color	amb,		/* Ambient 'curve' */
			diff,		/* Diffuse reflection 'curve' */
			spec,		/* Specular reflection 'curve' */
			translu,	/* Diffuse transmission 'curve' */
			body;		/* Specular transmission 'curve' */
	Float	srexp,			/* Specular reflection exponent */
		stexp,			/* Specular transmission exponent */
		statten,		/* Specular transmission attenuation */
		index,			/* Index of refraction */
		reflect,		/* Specular reflectivity */
		transp,			/* Specular transmittance */
		translucency;		/* Diffuse transmittance */ 
	char	noshadow;		/* No shadowing? */
	struct Surface *next;		/* Next surface in list (if any) */
} Surface;
 
/*
 * Linked list of (linked list of) surfaces.
 */
typedef struct SurfList {
	Surface *surf;
	struct SurfList *next;
} SurfList;
 
extern Surface	*SurfaceCreate(),
		*GetShadingSurf(),	/* application-provided */
		*SurfaceCopy();
 
extern SurfList	*SurfPop(), *SurfPush();
 
extern void	SurfaceBlend(), ColorBlend();
 
extern int	ComputeSurfProps();
Surface *SurfaceGetNamed(), *SurfaceFetchNamed();
#endif /* SURFACE_H */
