#include "FVF.hpp"

namespace swShader
{
	FVFFlags::FVFFlags()
	{
		flags = 0;
	}

	FVFFlags::FVFFlags(int flags)
	{
		this->flags = flags;
	}

	FVFFlags::~FVFFlags()
	{
	}

	FVFFlags FVFFlags::operator|(int flag) const
	{
		return flags | flag;
	}

	bool FVFFlags::operator!=(const FVFFlags &FVF) const 
	{
		return flags != FVF.flags;
	}
	
	bool FVFFlags::operator==(const FVFFlags &FVF) const
	{
		return flags == FVF.flags;
	}

	bool FVFFlags::hasRHW() const
	{
		return !!(flags & FVF_RHW);
	}
	
	bool FVFFlags::hasNormal() const
	{
		return !!(flags & FVF_NORMAL);
	}
	
	bool FVFFlags::hasColor() const
	{
		return !!(flags & FVF_COLOR);
	}
	
	bool FVFFlags::hasDiffuse() const
	{
		return !!(flags & FVF_DIFFUSE);
	}
	
	bool FVFFlags::hasLight() const
	{
		return !!(flags & FVF_LIGHT);
	}
	
	bool FVFFlags::hasSpecular() const
	{
		return !!(flags & FVF_SPECULAR);
	}

	bool FVFFlags::hasTexture(int i) const
	{
		return (((flags & FVF_TEX_MASK) >> FVF_TEX_SHIFT) & (1 << i)) != 0;
	}

	int FVFFlags::textureCount() const
	{
		return BITS((flags & FVF_TEX_MASK) >> FVF_TEX_SHIFT);
	}
}