#ifndef swShader_Stream_hpp
#define swShader_Stream_hpp

#include "Lockable.hpp"

namespace swShader
{
	class VS_2_0Assembler;

	class Stream : public Lockable
	{
		friend VS_2_0Assembler;

	public:
		enum Type
		{
			TYPE_INVALID,

			TYPE_FLOAT,
			TYPE_FLOAT1 = TYPE_FLOAT,
			TYPE_FLOAT2,				// Stored as float4
			TYPE_FLOAT3,				// Stored as float4
			TYPE_FLOAT4,
			TYPE_UBYTE4,
			TYPE_COLOR					// Color<byte>
		};

		enum Usage
		{
			USAGE_INVALID,

			USAGE_POSITION0,
			USAGE_POSITION1,
			USAGE_BLENDWEIGHT,
			USAGE_BLENDINDICES,
			USAGE_NORMAL0,
			USAGE_NORMAL1,
			USAGE_PSIZE,
			USAGE_TEXCOORD0,
			USAGE_TEXCOORD1,
			USAGE_TEXCOORD2,
			USAGE_TEXCOORD3,
			USAGE_TEXCOORD4,
			USAGE_TEXCOORD5,
			USAGE_TEXCOORD6,
			USAGE_TEXCOORD7,
			USAGE_TANGENT,
			USAGE_BINORMAL,
			USAGE_TESSFACTOR,
			USAGE_POSITIONT,
			USAGE_COLOR0,
			USAGE_COLOR1,
			USAGE_FOG,
			USAGE_DEPTH,
			USAGE_SAMPLE
		};

		Stream();
		Stream(Type type, Usage usage, void **buffer);

		~Stream();

		Type getType() const;
		Usage getUsage() const;
		const void *getBuffer();
		void setBuffer(void **buffer);

	private:
		Type type;
		Usage usage;
		void **buffer;
	};
}

#endif   // swShader_Stream_hpp
