#ifndef VertexBuffer_hpp
#define VertexBuffer_hpp

#include "Lockable.hpp"

#include "Types.hpp"
#include "Color.hpp"

namespace swShader
{
	class Renderer;
	class VS_2_0Assembler;

	class VertexBuffer : public Lockable
	{
		friend Renderer;
		friend VS_2_0Assembler;

	public:
		VertexBuffer(unsigned int flags, int n = 0);

		~VertexBuffer();

		void realloc(int n);
		int size() const;

	protected:
		void allocate(unsigned int flags, int n);

		bool hasRHW() const;
		bool hasNormal() const;
		bool hasDiffuse() const;
		bool hasSpecular() const;
		int numTexCoords() const;

		static int fourfold(int n);

		unsigned int flags;
		int numVertices;
		int padding;

		float4 *position[2];
		float4 *blendWeight;
		byte4 *blendIndices;
		float4 *normal[2];
		float *pSize;
		float4 *texCoord[8];
		float4 *tangent;
		float4 *binormal;
		float *tessFactor;
		float4 *positiont;
		Color<byte> *color[2];
		float *fog;
		float *depth;
		float4 *sample;
	};
}

#endif VertexBuffer_hpp