#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine DisBar (X, Y, N, K, XC, YC, NC)


*****************************************************************
*                                                               *
*    Subroutine Clip_Discrete_or_Bar_Graph_Plots                *
*                                                               *
*       Like in subroutine clip, this subroutine clips the      *
*       curve to be displayed in the window. The routine        *
*       uses the window's max and min points in order to        *
*       orient the point about the clipping window. The         *
*       point is included if the 'x' point is not within        *
*       the window, else the point is excluded. If the          *
*       point's 'y' position is above or below, the position    *
*       is reset to the window's maximum or minimum setting,    *
*       respectively.                                           *
*                                                               *
*****************************************************************


        Real           WXmax, WXmin, WYmax, WYmin
        Common /windw/ WXmax, WXmin, WYmax, WYmin
        Save   /windw/

        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Real    X(max,num), Y(max,num), XC(maxC,num), YC(maxC,num)
        Integer N, K, NC, I


*       (* Initialize the number of clipped points to zero. *)
        NC = 0

*       (* Check every point to see if it is within the window. If so,
*          put it in the clipped arrays, XC & YC. *)
        DO 100 I = 1, N
          IF (X(I,K) .GE. WXmin .AND. X(I,K) .LE. WXmax) THEN
            NC = NC +1
            XC(NC,K) = X(I,K)

*           (* If the point is above or below the window, then set
*              the clipped point to the corresponding man or min 
*              window. *)
            IF (Y(I,K) .GT. WYmax) THEN
              YC(NC,K) = WYmax
            ELSE IF (Y(I,K) .LT. WYmin) THEN
              YC(NC,K) = WYmin
            ELSE
              YC(NC,K) = Y(I,K)
            ENDIF
          ENDIF
  100   CONTINUE

        RETURN
        END
