#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine GigiD (XC, YC, NC, NumCrv, Crvtyp, NumTic, 
     +                    term, shadng)


*****************************************************************
*                                                               *
*  Subroutine Device_Gigi                                       *
*                                                               *
*     Subroutine gigi is a device dependent routine, used       *
*     to plot the object stored in 'XC' & 'YC' with NC          *
*     points. The arrays are stored in normalized device        *
*     coordinates, the points are converted into GIGI de-       *
*     vice, and then position (P) and vector (V) commands       *
*     are used to draw the line.                                *
*                                                               *
*     The clipped curve is stored in arrays 'XC', 'YC',         *
*     with 'NC' points.  If a continuous plot is desired        *
*     the object is stored as a series of lines segments        *
*     else, if a point plot is desired the object is            *
*     stored as a series of points.                             *
*                                                               *
*****************************************************************


        Integer    cont, point, discrt, bar, marker
        Parameter (cont = 1, point = 2, discrt = 3, bar = 4, marker = 5)

        Character *7    crv(3)
        Common /Crvlbl/ crv
        Save   /Crvlbl/

        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Integer         CColor(3), Backgd
        Common /Cdefs/  CColor, Backgd
        Save   /Cdefs/

        Integer         CType(3)
        Common /lntyp/  CType
        Save   /lntyp/

        Real     XC(maxC,num), YC(maxC,num), golden
        Integer  NumCrv, NC(NumCrv), CrvTyp(3), NumTic(2), term
        Integer  TXmax, TXmin, DXmax, DXmin, DYmax, DYmin, legend, 
     +           Gx, Gy, I, J
        Logical  shadng

        Integer    typln(5)
        Character  PntTyp(5)
        Data       PntTyp /'*','+','0','x','o'/
        Data       typln /1,4,3,2,5/

        Call clear(term)

*       (* Puts the terminal into graphics mode. *)
        Write (*,10) Char(27)
   10   Format (a,'Pp')

*       (* Reset the gigi to standard defaults. *)
        Write (*,20) Backgd
   20   Format ('W(V I7 P1) S(C1 I',I1,') T(W(V)) T(D0,S1,D0)')

        golden = (sqrt(5.0) + 1.0)/2.0
        DYmin = 25
        DYmax = 400
        DXmin = 150
        DXmax = (DYmax - DYmin)*golden + DXmin
        legend = 110

        Call GigiBx(term, NumTic, DXmax, DXmin, DYmax, DYmin)

        DO 100 J = 1, NumCrv
          Write (*,30) CColor(J), typln(Ctype(J))
   30     Format ('W(I',i1,'P',I1,')')
          IF (shadng) THEN
            Write (*,40) DYmax
   40       Format ('W(S[,',i3,'])')
          ENDIF

*         (* Check to see what type of plot is desired. *)
          IF (CrvTyp(j) .EQ. discrt) THEN

*           (* Then convert, position, and vector the line segments. *)
            DO 200 I = 1, NC(J)
*             (* Position the point to the bottom of the x-axis. *)
              Gx = XC(I,J)*(DXmax - DXmin) +DXmin
              Gy = DYmax
              Write (*,50) Gx, Gy
   50         Format ('P[',i3,',',i3,']')

*             (* Vector to the top of the 'y' position. *)
              Gy = (DYmin - DYmax)*YC(I,J) +DYmax
              Write (*,60) Gx, Gy 
   60         Format ('V[',i3,',',i3,']')
  200       CONTINUE

          ELSE IF (CrvTyp(j) .EQ. bar) THEN

*             (* Position the point on the x-axis. *)
              Gx = XC(1,J)*(DXmax - DXmin) +DXmin
              Gy = DYmax
              Write (*,50) Gx, Gy

              TXmax = XC(1,J)
              TXmin = XC(1,J)
*           (* Then convert, position, and vector the line segments. *)
            DO 300 I = 1, NC(J) -1

              IF (TXmax .LT. XC(I,J)) TXmax = XC(I,J)
              IF (TXmin .GT. XC(I,J)) TXmin = XC(I,J)

*             (* Vector to the top of the 'y' position. *)
              Gy = (DYmin - DYmax)*YC(I,J) +DYmax
              Write (*,60) Gx, Gy 
*             (* Vector to the next 'x' position. *)
              Gx = XC(I+1,J)*(DXmax - DXmin) +DXmin
              Write (*,60) Gx, Gy 
*             (* Vector back down to the x-axis. *) 
              Gy = DYmax
              Write (*,60) Gx, DYmax
  300       CONTINUE
*           (* Repeat the process for the last point. *)
              Gy = (DYmin - DYmax)*YC(NC(J),J) +DYmax
            Write (*,60) Gx, Gy

            IF ((Gx +(TXmax - TXmin)/NC(J)) .LT. DXmax) THEN
              Gx = Gx + (TXmax - TXmin)/NC(J)
            ELSE
              Gx = DXmax
            ENDIF

            Write (*,60) Gx, Gy
            Write (*,60) Gx, DYmax
          ELSE
            IF (CrvTyp(j) .EQ. cont .OR. CrvTyp(j) .EQ. marker) THEN

*             (* Then convert, position, and vector the line segments. *)
              DO 400 I = 1, NC(J), 2
*               (* Position the first point. *)
                Gx = XC(I,J)*(DXmax - DXmin) +DXmin
                Gy = (DYmin - DYmax)*YC(I,J) +DYmax
                Write (*,50) Gx, Gy

*               (* Vector to the second point. *)
                Gx = XC(I+1,J)*(DXmax - DXmin) +DXmin
                Gy = (DYmin - DYmax)*YC(I+1,J) +DYmax
                Write (*,60) Gx, Gy 
  400         CONTINUE
            ENDIF

            IF (CrvTyp(j) .EQ. point .OR. CrvTyp(j) .EQ. marker) THEN

*             (* Then position the point, and mark it. *)
              DO 500 I = 1, NC(J)
*               (* Position the point. *)
                Gx = XC(I,J)*(DXmax - DXmin) +DXmin -5
                Gy = (DYmin - DYmax)*YC(I,J) +DYmax -8
                Write (*,70) Gx, Gy, PntTyp(J)
   70           Format ('P[',i3,',',i3,']  T(S1)''',a1,'''')
  500         CONTINUE
            ENDIF
          ENDIF

          IF (CrvTyp(j) .EQ. point .OR. CrvTyp(j) .EQ. marker) THEN
            Write (*,80) legend, crv(j), (PntTyp(J),I=1,5)
  80        Format ('W(S0)  P[',i3,',455] T(S1)''',a7,' ',
     +              5(' ',a1),'''')
          ENDIF

          IF (CrvTyp(j) .NE. point) THEN
            Write (*,90) legend, crv(j)
  90        Format ('W(S0)  P[',i3,',455] T(S1)''',a7,' '''
     +              'P[+5,+7] V[+90]')
          ENDIF
          legend = legend +200


  100   CONTINUE

        Write (*,110)
  110   Format('P[0,0] S(C0 I0) W(17)')
        Read (*,'(a1)') 

*         (* Takes the terminal out of graphic mode. *)
          Write (*,120) Char(27), Char(92)
  120     Format (2a1)

        RETURN
        END
