#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************




CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine UserSn (X, Y, Numpt, NumCrv, term)


*****************************************************************
*                                                               *
*    Subroutine User_Single_Input                               *
*                                                               *
*      This routine gets the XY points, for the curve.          *
*      The user is prompted for the number of simultaneous      *
*      curves. The routine asks the user for the number of      *
*      data points to be entered. Prompts are used to read      *
*      in the X & Y array.                                      *
*                                                               *
*      Input is expected to be in the following format:         *
*                                                               *
*       X      Y1     Y2  ...  Ymax                             *
*                                                               *
*      for each set of points.                                  *
*                                                               *
*      Minor error checking is done by this routine; mainly     *
*      to make sure the user enters a reasonable amount of      *
*      simultaneous curves, and that the number of data         *
*      points are of a reasonible size.                         *
*                                                               *
*****************************************************************

        Logical         cldrun
        Common /strtup/ cldrun
        Save   /strtup/

        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Character    ans
        Real         X(max,num), Y(max,num), Xval
        Integer      NumCrv, Numpt(num), term, I, J


    3     Call clear(term)
          Write (*,30) 
   30     Format(/,15x,'Keyboard Input',///
     +           ,5x,'Please enter the number of points for each'
     +           ' curve ...')
          Read (*,*,err=3) J

          IF (J .LT. 2  .OR. J .GT. max) THEN
*           (* Disaster!! Too many data points. Allow the user to 
*              either quit or retry to enter the number of points. *)
    4       Call clear(term)
            Write (*,40) J
   40       Format(/,15x,'Keyboard Input',///,5x,'Sorry, but ',i4
     +              ,' is not a valid number',' of points.',//
     +               ,5x,'Do you wish to stop the program? (Y/N)... ')
            Read (*,'(a1)',err=4) ans
            IF (ans .EQ. 'Y' .OR. ans .EQ. 'y') THEN
              Write (*,50)
   50         Format (//,5x,'Goodbye!'//)
              STOP
            ENDIF
            GOTO 3
          ELSE
*
*          All curves have the same number of points.
*
            DO 32 I = 1,NumCrv
              Numpt(I) = J
   32       CONTINUE
*           (* Read in the X & Y points. *)
            Do 400 J = 1,Numpt(1)
    5         Call clear(term)
              Write(*,60) J
   60         Format(/,15x,'Keyboard Input',///,5x,
     +                     'Enter X and Ys, point:',i3)
              Read (*,*,err=5,end=300) Xval, (Y(J,I),I=1,NumCrv)
              DO 63 I=1,NumCrv
                X(J,I) = Xval
   63         CONTINUE
  400       CONTINUE
          ENDIF
  300     CONTINUE

        RETURN
        END
