# libx86

A hardware-independent library for executing real-mode x86 code

## What is it?

It's often useful to be able to make real-mode x86 BIOS calls from userland. [lrmi][lrmi] provides a simple interface to this for x86 machines, but this doesn't help on other platforms. libx86 provides the lrmi interface, but will also run on platforms such as amd64 and alpha.
How does it work?

libx86 is built on top of two bodies of code - lrmi and x86emu. x86emu is a generic x86 emulator originally provided by Scitech and now maintained as part of the [X.org][xorg] distribution.

On x86 platforms, libx86 will use the vm86 interface provided by most modern kernels in order to execute code. On non-x86 platforms, an interface layer is provided to allow x86emu to be used to execute lrmi function calls. The API is identical in both cases, meaning that applications can be written without having to care about what's going on behind the scenes.

## How do I use it?

If you already have an lrmi-using application, simply:

* Replace `#include "lrmi.h"` with `#include <libx86.h>`
* Don't build `lrmi.c`
* Link against libx86 - static and dynamic libraries are provided
* If not, here is some sample code for a trivial libx86 application.

It simply executes the code found at address c000:0003.

```c
#include <libx86.h>
#include <stdio.h>

int main() {
    struct LRMI_regs r;
    memset(&r;, 0, sizeof(r));
    
    r.cs = 0xc000;
    r.ip = 0x0003;

    LRMI_init();

    if (!LRMI_call(&r;)) {
        fprintf(stderr, "Error: Something went wrong performing realmode call\n";
    }
}
```

## Where do I get it?

[Alternate source][alt-source] since the [upstream] url no longer exists.

## Who wrote it and what license is it under?

* lrmi is Copyright © 1998-2005 Josh Vanderhoof
* x86emu is Copyright © 1996-1999 SciTech Software, Inc., Copyright © David Mosberger-Tang and Copyright © 1999 Egbert Eich
* libx86 is Copyright © 2005-2006 Jonathan McDowell and Copyright © 2005-2006 Matthew Garrett

Check the package for the precise licensing terms - the details vary slightly between the different sections of code, but effectively you can do whatever you want with the code (including incorporating modified versions into your non-free application) providing that the copyright notices are maintained.

## What needs to be done?

* Update lrmi to the latest code (last time I tried this I ran into a couple of weird problems, but I should really try again).
* Make sure it builds and works on non-Linux platforms - in theory there's no linux-specific code, but it would be good to check.

[lrmi]:https://sourceforge.net/projects/lrmi/
[xorg]:https://www.x.org/wiki/
[alt-source]:https://gitlab.archlinux.org/grawlinson/libx86
[upstream]:https://www.codon.org.uk/~mjg59/libx86/
