'\"
'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /user6/ouster/tcl/man/RCS/ExprLong.man,v 1.4 92/01/02 14:22:21 ouster Exp $ SPRITE (Berkeley)
'\" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'	# BS - start boxed text
'	# ^y = starting y location
'	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'	# VS - start vertical sidebar
'	# ^Y = starting y location
'	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'	# Special macro to handle page bottom:  finish off current
'	# box/sidebar if in box/sidebar mode, then invoked standard
'	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'	# DS - begin display
.de DS
.RS
.nf
.sp
..
'	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS Tcl_ExprLong tcl
.BS
.SH NAME
Tcl_ExprLong, Tcl_ExprDouble, Tcl_ExprBool, Tcl_ExprString \- evaluate an expression
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.VS
.sp
int
\fBTcl_ExprLong\fR(\fIinterp, string, longPtr\fR)
.sp
int
\fBTcl_ExprDouble\fR(\fIinterp, string, doublePtr\fR)
.sp
int
\fBTcl_ExprBoolean\fR(\fIinterp, string, booleanPtr\fR)
.sp
int
\fBTcl_ExprString\fR(\fIinterp, string\fR)
.SH ARGUMENTS
.AS Tcl_Interp *interp
.AP Tcl_Interp *interp in
Interpreter in whose context to evaluate \fIstring\fR.
.AP char *string in
Expression to be evaluated.  Must be in writable memory (the expression
parser makes temporary modifications to the string during parsing, which
it undoes before returning).
.AP long *longPtr out
Pointer to location in which to store the integer value of the
expression.
.AP int *doublePtr out
Pointer to location in which to store the floating-point value of the
expression.
.AP int *booleanPtr out
Pointer to location in which to store the 0/1 boolean value of the
expression.
.BE

.SH DESCRIPTION
.PP
These four procedures all evaluate a string expression, returning
the result in one of four different forms.
The expression is given by the \fIstring\fR argument, and it
can have any of the forms accepted by the \fBexpr\fR command.
The \fIinterp\fR argument refers to an interpreter used to
evaluate the expression (e.g. for variables and nested Tcl
commands) and to return error information.  \fIInterp->result\fR
is assumed to be initialized in the standard fashion when any
of the procedures are invoked.
.PP
For all of these procedures the return value is a standard
Tcl result:  \fBTCL_OK\fR means the expression was succesfully
evaluated, and \fBTCL_ERROR\fR means that an error occurred while
evaluating the expression.  If \fBTCL_ERROR\fR is returned then
\fIinterp->result\fR will hold a message describing the error.
If an error occurs while executing a Tcl command embedded in
\fIstring\fR, then that error will be returned.
.PP
If the expression is successfully evaluated, then its value will
be returned in one of four forms, depending on which procedure
is invoked.
\fBTcl_ExprLong\fR stores an integer value at \fI*longPtr\fR.
If the expression's actual value was a floating-point number,
then it is truncated to an integer.
If the expression's actual value was a non-numeric string then
an error is returned.
.PP
\fBTcl_ExprDouble\fR stores a floating-point value at \fI*doublePtr\fR.
If the expression's actual value was an integer, it is converted to
floating-point.
If the expression's actual value was a non-numeric string then
an error is returned.
.PP
\fBTcl_ExprBoolean\fR stores a 0/1 integer value at \fI*booleanPtr\fR.
If the expression's actual value was an integer or floating-point
number, then \fBTcl_ExprBoolean\fR stores 0 at \fI*booleanPtr\fR if
the value was zero and 1 otherwise.
If the expression's actual value was a non-numeric string then
an error is returned.
.PP
\fBTcl_ExprString\fR returns the value of the expression as a
string stored in \fIinterp->result\fR.
If the expression's actual value was an integer or floating-point
number, then \fBTcl_ExprString\fR converts it to string (using \fBsprintf\fR
with a ``%d'' or ``%g'' converter).

.SH KEYWORDS
boolean, double, evaluate, expression, integer, string
.VE
