#!/bin/sh -e
if [ "$(id -u)" = 0 ]
then
  echo "Don't run this script as root!"
  exit 1
fi

I386_ROOT="${WINE_i386_ROOT:-$HOME/.i386-wine-pkg}"

mkdir -p "$I386_ROOT"
ABI=$(pkg config ABI | sed s/amd64/i386/)
echo pkg -o ABI="$ABI" -o INSTALL_AS_USER=true -o RUN_SCRIPTS=false --rootdir "$I386_ROOT" "$@"
exec pkg -o ABI="$ABI" -o INSTALL_AS_USER=true -o RUN_SCRIPTS=false --rootdir "$I386_ROOT" "$@"
