--- libsylph/ssl.c.orig	2017-02-02 08:02:49 UTC
+++ libsylph/ssl.c
@@ -258,6 +258,13 @@ gboolean ssl_init_socket_with_method(SockInfo *sockinf
 		return FALSE;
 	}
 
+#ifdef SSL_CTRL_SET_TLSEXT_HOSTNAME
+	if (!SSL_set_tlsext_host_name(sockinfo->ssl, sockinfo->hostname)) {
+		g_warning("Error setting servername extension\n");
+		return FALSE;
+	}
+#endif
+
 	SSL_set_fd(sockinfo->ssl, sockinfo->sock);
 	while ((ret = SSL_connect(sockinfo->ssl)) != 1) {
 		err = SSL_get_error(sockinfo->ssl, ret);
