#!/bin/sh
# --- T2-COPYRIGHT-NOTE-BEGIN ---
# This copyright note is auto-generated by ./scripts/Create-CopyPatch.
# 
# T2 SDE: package/.../xorg-server/xvfb-run.sh
# Copyright (C) 2005 The T2 SDE Project
# Copyright (C) XXXX - 2005 Debian
# 
# More information can be found in the files COPYING and README.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License. A copy of the
# GNU General Public License can be found in the file COPYING.
# --- T2-COPYRIGHT-NOTE-END ---

# $Id: xvfb-run 2166 2005-01-27 07:54:19Z branden $
# from: http://necrotic.deadbeast.net/xsf/XFree86/trunk/debian/local/xvfb-run

# This script starts an instance of Xvfb, the "fake" X server, runs a command
# with that server available, and kills the X server when done.  The return
# value of the command becomes the return value of this script.
#
# If anyone is using this to build a Debian package, make sure the package
# Build-Depends on xvfb, xbase-clients, and xfonts-base.
#
# This script has been modified by Robin Haberkorn to remove dependencies on
# GNU `fmt` and `getopt` for BSD compatibility.

set -e

PROGNAME=xvfb-run
SERVERNUM=99
AUTHFILE=
ERRORFILE=/dev/null
STARTWAIT=3
XVFBARGS="-screen 0 640x480x8"
LISTENTCP="-nolisten tcp"
XAUTHPROTO=.

# Display a message, wrapping lines at the terminal width.
message () {
    echo "$PROGNAME: $*" | fmt
}

# Display an error message.
error () {
    message "error: $*" >&2
}

# Find a free server number by looking at .X*-lock files in /tmp.
find_free_servernum() {
    # Sadly, the "local" keyword is not POSIX.  Leave the next line commented in
    # the hope Debian Policy eventually changes to allow it in /bin/sh scripts
    # anyway.
    #local i

    i=$SERVERNUM
    while [ -f /tmp/.X$i-lock ]; do
        i=$(($i + 1))
    done
    echo $i
}

SERVERNUM=$(find_free_servernum)

if [ -z "$*" ]; then
    error "need a command to run"
    exit 2
fi

if ! which xauth >/dev/null; then
    error "xauth command not found"
    exit 3
fi

# If the user did not specify an X authorization file to use, set up a temporary
# directory to house one.
if [ -z "$AUTHFILE" ]; then
    XVFB_RUN_TMPDIR="${TMPDIR:-/tmp}/$PROGNAME.$$"
    if ! mkdir -p -m 700 "$XVFB_RUN_TMPDIR"; then
        error "temporary directory $XVFB_RUN_TMPDIR already exists"
        exit 4
    fi
    AUTHFILE=$(mktemp -p "$XVFB_RUN_TMPDIR" Xauthority)
fi

# Start Xvfb.
MCOOKIE=$(mcookie)
XAUTHORITY=$AUTHFILE xauth add ":$SERVERNUM" "$XAUTHPROTO" "$MCOOKIE" \
  >"$ERRORFILE" 2>&1
XAUTHORITY=$AUTHFILE Xvfb ":$SERVERNUM" $XVFBARGS $LISTENTCP >"$ERRORFILE" \
  2>&1 &
XVFBPID=$!
sleep "$STARTWAIT"

# Start the command and save its exit status.
set +e
DISPLAY=:$SERVERNUM XAUTHORITY=$AUTHFILE "$@" 2>&1
RETVAL=$?
set -e

# Kill Xvfb now that the command has exited.
kill $XVFBPID

# Clean up.
XAUTHORITY=$AUTHFILE xauth remove ":$SERVERNUM" >"$ERRORFILE" 2>&1
if [ -n "$XVFB_RUN_TMPDIR" ]; then
    if ! rm -r "$XVFB_RUN_TMPDIR"; then
        error "problem while cleaning up temporary directory"
        exit 5
    fi
fi

# Return the executed command's exit status.
exit $RETVAL

# vim:set ai et sts=4 sw=4 tw=80:
