/* -- AIX/6000 System monitor 
**
**     get_afsstat.c
**
** Copyright (c) 1993-1998 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#if defined(HAVE_AFS)

#include <stdio.h.h>
#include <rx/rx.h>
#include <afs/afs_stats.h>
#include <nlist.h>
#include "get_afsstat.h"
#include "getkmemdata.h"


#define AFS_VALUE(index) (afsnames[index].n_value)
#define NUMBER_AFS_NLISTS  3
#define NLIST_AFS_CMSTATS  0
#define NLIST_AFS_RXSTATS  1
#define NLIST_AFS_CMPERF   2

struct nlist afsnames[] = {
    {"afs_cmstats",      0, 0, 0, 0, 0},
    {"rx_stats",         0, 0, 0, 0, 0},
    {"afs_stats_cmperf", 0, 0, 0, 0, 0},
    {NULL,               0, 0, 0, 0, 0},
};

int afsinit = 0;



void get_afsstat(afsstat_t *afsstatp)
{
    struct rx_stats         rx_stats;
    struct afs_CMStats      cmp;
    struct afs_stats_CMPerf perf;

    if (!afsinit) {
        if (show_afs &&
            (knlist(afsnames, NUMBER_AFS_NLISTS, sizeof(struct nlist)) == -1)) {
	    perror("get_afsstat: afs not configured");
	    show_afs = 0;
        }
        afsinit = 1;
    }

    getkmemdata((char *) &cmp, sizeof(struct afs_CMStats),
                (caddr_t) AFS_VALUE(NLIST_AFS_CMSTATS));
    getkmemdata((char *) &rx_stats, sizeof(struct rx_stats),
                (caddr_t) AFS_VALUE(NLIST_AFS_RXSTATS));
    getkmemdata((char *) &perf, sizeof(struct afs_stats_CMPerf),
                (caddr_t) AFS_VALUE(NLIST_AFS_CMPERF));


    afsstatp->lookup         = cmp.callInfo.C_afs_lookup;
  /*afsstatp->readlink       = cmp.callInfo.C_afs_readlink;*/
  /*afsstatp->getattr        = cmp.callInfo.C_afs_getattr;*/
    afsstatp->GetVCache      = cmp.callInfo.C_afs_GetVCache;
    afsstatp->DRead          = cmp.callInfo.C_DRead;
    afsstatp->GetDCache      = cmp.callInfo.C_afs_GetDCache;

    afsstatp->packetRequests = rx_stats.packetRequests;

/*  afsstatp->dcacheHits     = perf.dcacheHits;
    afsstatp->vcacheHits     = perf.vcacheHits;
    afsstatp->dcacheMisses   = perf.dcacheMisses;
    afsstatp->vcacheMisses   = perf.vcacheMisses;
    afsstatp->dlocalAccesses = perf.dlocalAccesses;
    afsstatp->vlocalAccesses = perf.vlocalAccesses;*/

    afsstatp->cacheHits      = perf.dcacheHits      + perf.vcacheHits;
    afsstatp->cacheAccess    = perf.dlocalAccesses  + perf.vlocalAccesses +
		               perf.dremoteAccesses + perf.vremoteAccesses;

    return;

} /* get_afsstat */

#endif /* HAVE_AFS */
