/* -- AIX/6000 System monitor 
**
**     get_sysvminfo.c
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-1998 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <stdio.h>	/* for perror */
#include <nlist.h>
#include <sys/utsname.h>
#include "get_sysvminfo.h"
#include "getkmemdata.h"

#define N_VALUE(index) ((caddr_t)kernelnames[index].n_value)
#define KNSTRUCTS_CNT 3
#define NLIST_SYSINFO 0
#define NLIST_VMKER 1
#define NLIST_VMINFO 2
struct nlist kernelnames[] = {
    {"sysinfo", 0, 0, 0, 0, 0},
    {"vmker",   0, 0, 0, 0, 0},
    {"vmminfo", 0, 0, 0, 0, 0},
    {NULL,      0, 0, 0, 0, 0},
};

struct vmker1 *vm42;
struct vmker2 *vm43;

extern struct utsname unames;
int aix43;
int nlistdone = 0;
/***************************************************************************
 *                      DATA CAPTURE FUNCTIONS                             *
 ***************************************************************************/

void
get_sys_vm_info(struct sysinfo *si, struct vmker *vmk, struct vminfo *vm)
{

    if (!nlistdone) {
        if (knlist(kernelnames, KNSTRUCTS_CNT, sizeof(struct nlist)) == -1)
	    perror("knlist, entry not found");
        nlistdone = 1;
        aix43 = (!strcmp(unames.version, "4") && !strcmp(unames.release, "3")) ?
                1 : 0;
        if (aix43)
            vm43 = malloc(sizeof(struct vmker2));
        else
            vm42 = malloc(sizeof(struct vmker1));
    }

    /*
     * Get the system info structure from the running kernel.
     * Get the kernel virtual memory vmker structure
     * Get the kernel virtual memory info structure
     */
    getkmemdata(si,  sizeof(struct sysinfo), N_VALUE(NLIST_SYSINFO));
    getkmemdata(vm,  sizeof(struct vminfo),  N_VALUE(NLIST_VMINFO));
    if (aix43) {
        getkmemdata(vm43, sizeof(struct vmker2),   N_VALUE(NLIST_VMKER));
        vmk->totalmem    = vm43->totalmem;
        vmk->badmem      = vm43->badmem;
        vmk->freemem     = vm43->freemem;
        vmk->maxperm     = vm43->maxperm;
        vmk->numperm     = vm43->numperm;
        vmk->totalvmem   = vm43->totalvmem;
        vmk->freevmem    = vm43->freevmem;
        vmk->nonpinnable = vm43->nonpinnable;
        vmk->numclient   = vm43->numclient;
        vmk->maxclient   = vm43->maxclient;
    }
    else {
        getkmemdata(vm42, sizeof(struct vmker1),   N_VALUE(NLIST_VMKER));
        vmk->totalmem    = vm42->totalmem;
        vmk->badmem      = vm42->badmem;
        vmk->freemem     = vm42->freemem;
        vmk->maxperm     = vm42->maxperm;
        vmk->numperm     = vm42->numperm;
        vmk->totalvmem   = vm42->totalvmem;
        vmk->freevmem    = vm42->freevmem;
        vmk->nonpinnable = vm42->nonpinnable;
        vmk->numclient   = vm42->numclient;
        vmk->maxclient   = vm42->maxclient;
    }

    if (vmk->badmem)
        vmk->badmem -= 16; /* adjust memory for 220 models? */
                           /* and also on C10 models */
                           /* does it have something to do with unused
                              SIMM slots ??? */
    vmk->totalmem -= vmk->badmem;
    /*
     * round the amount of memory to the nearest 4 MB, For one J series
     * machine the vmk->totalmem did not give a correct number
     */
    vmk->totalmem = (vmk->totalmem*4096/1024/1024+2)*4/4*1024/4096*1024;

    return;

} /* get_sys_vm_info */
