/* -- AIX/6000 System monitor 
**
**     get_sysvminfo.h
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-1998 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <sys/types.h>
#include <sys/sysinfo.h>
#include <sys/vminfo.h>

/*
 * vmker struct is kernelstruct (undocumented) 
 * vmker seems to hold some kernels virtual memory variables 
 * vmker1 works up to AIX 4.2
 */
struct vmker1 {
    uint n0, n1, n2, n3, n4, n5, n6, n7;
    uint pageresv; /* reserved paging space blocks */
    uint totalmem; /* total number of pages memory */
    uint badmem;   /* this is used in RS/6000 model 220 and C10 */
    uint freemem;  /* number of pages on the free list */
    uint maxperm;  /* max number of frames no working */
    uint numperm;  /* seems to keep other than text and data segment usage */
                   /* the name is taken from /usr/lpp/bos/samples/vmtune.c */
    uint totalvmem;
    uint freevmem;
    uint n16;
    uint nonpinnable; /* number of reserved (non-pinable) memory pages */
    uint n18, n19;
    uint numclient;/* number of client frames */
    uint maxclient;/* max number of client frames */
};

/*
 * vmker2 works for AIX 4.3
 */
struct vmker2 {
    uint n0, n1, n2, n3, n4, n5, n6, n7;
    uint totalmem; /* total number of pages memory */
    uint badmem;   /* this is used in RS/6000 model 220 and C10 */
    uint freemem;  /* number of pages on the free list */
    uint maxperm;  /* max number of frames no working */
    uint numperm;  /* seems to keep other than text and data segment usage */
                   /* the name is taken from /usr/lpp/bos/samples/vmtune.c */
    uint totalvmem;
    uint freevmem;
    uint n15;
    uint pageresv; /* reserved paging space blocks */
    uint nonpinnable; /* number of reserved (non-pinable) memory pages */
    uint n18;
    uint numclient;/* number of client frames */
    uint maxclient;/* max number of client frames */
};

/*
 * So we build our own with known values...
 * Some fields are not certain yet:
 *         C = Certain, A = Almost certain, U = uncertain
 * All fields are in 4k pages
 */
struct vmker {
    uint totalmem; /* C - total number of pages memory */
    uint badmem;   /* A - this is used in RS/6000 model 220 and C10 */
    uint freemem;  /* A - number of pages on the free list */
    uint maxperm;  /* C - max number of frames no working */
    uint numperm;  /* C - other than text and data segment usage */
                   /* the name is taken from /usr/lpp/bos/samples/vmtune.c */
    uint totalvmem;/* C - total paging space */
    uint freevmem; /* C - free pagins space */
    uint pageresv; /* C - reserved paging space blocks */
    uint nonpinnable; /* U - number of reserved (non-pinable) memory pages */
    uint numclient; /* C - number of client frames */
    uint maxclient; /* A - max number of client frames */
};

void get_sys_vm_info(struct sysinfo *si, struct vmker *vmk, struct vminfo *vm);
