/* -- AIX/6000 System monitor 
**
**     get_top.h
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-1998 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <sys/types.h>

#define TOPCPU_USERNAME_LEN 9
#define TOPCPU_PROGNAME_LEN 32
#define NPROCS 5000

#define TOPSORT_CPU  1
#define TOPSORT_PAGE 2
#define TOPSORT_RES  3
#define TOPSORT_VIR  4

typedef struct {                                  /*        Size */
    uid_t   uid;                                  /*           4 */
    pid_t   pid;                                  /*           4 */
    pid_t   ppid;                                 /*           4 */
    u_char  pri;                                  /*           1 */
    u_char  nice;                                 /*           1 */
    u_char  stat;                                 /*           1 */
    char    username[TOPCPU_USERNAME_LEN];        /*           9 */
    char    progname[TOPCPU_PROGNAME_LEN];        /*          20 */
    u_long  memsize_1k;                           /*           4 */
    u_long  ressize_1k;                           /*           4 */
    u_long  pageflt;                              /*           4 */
    time_t  starttime;                            /*           4 */
    double  cpu_utime;                            /*           4 */
    double  cpu_stime;                            /*           4 */
    u_short deltapageflt;                         /*           2 */
    u_short cputime_prs;      /* divide by 10  */ /* CPU%      2 */
    u_long  tty;                                  /*           4 */

} topcpu_t;                                    



int get_topcpu(topcpu_t *top, int ntops);

/* Usage:
 *   topcpu_t topcpu[100];
 *   int n;
 *   n = get_topcpu(topcpu, 100);
 */

