/* -- AIX/6000 System monitor 
**
**     print_nfsstat.c
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-1998 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <curses.h>
#include "get_nfsstat.h"
#include "print_nfsstat.h"
#include "print.h"

extern FILE *logfp;

#define NFSclD(a) (nfs1->clstat.a - nfs2->clstat.a)
#define NFSsvD(a) (nfs1->svstat.a - nfs2->svstat.a)
#define NFSRATE(a) NFSclD(a) / refresh_time, NFSsvD(a) / refresh_time

/***************************************************************************
 *                      PRINTING FUNCTIONS                                 *
 ***************************************************************************/

void
print_nfsstat_init()
{
    int x, y;

    x = 29 + 14; y = 15;

    BOLDON;
    move(y + 0, x - 14); printw("Client Server NFS/s");
    BOLDOFF;
    NAMECOLON;
    move(y + 1, x); printw("calls");
    move(y + 2, x); printw("retry");
    move(y + 3, x); printw("getattr");
    move(y + 4, x); printw("lookup");
    move(y + 5, x); printw("read");
    move(y + 6, x); printw("write");
    move(y + 7, x); printw("other\n");
    NAMECOLOFF;

    return;

} /* print_nfsstat_init */



void
print_nfsstat(double refresh_time, t_nfs_stats *nfs1, t_nfs_stats *nfs2)
{
    int x, y, client_other, server_other;

    x = 29; y = 15;
    move(y + 1, x); printw("%6.1f %6.1f", NFSRATE(ncalls));
    move(y + 2, x); printw("%6.1f %6.1f", (nfs1->rcstat.rcretrans -
                                           nfs2->rcstat.rcretrans) /
                                           refresh_time, 0);
    move(y + 3, x); printw("%6.1f %6.1f", NFSRATE(reqs[RFS_GETATTR]));
    move(y + 4, x); printw("%6.1f %6.1f", NFSRATE(reqs[RFS_LOOKUP]));
    move(y + 5, x); printw("%6.1f %6.1f", NFSRATE(reqs[RFS_READ]));
    move(y + 6, x); printw("%6.1f %6.1f", NFSRATE(reqs[RFS_WRITE]));
    client_other = NFSclD(reqs[RFS_NULL])
                 + NFSclD(reqs[RFS_SETATTR])
                 + NFSclD(reqs[RFS_ROOT])
                 + NFSclD(reqs[RFS_READLINK])
                 + NFSclD(reqs[RFS_WRITECACHE])
                 + NFSclD(reqs[RFS_CREATE])
                 + NFSclD(reqs[RFS_REMOVE])
                 + NFSclD(reqs[RFS_RENAME])
                 + NFSclD(reqs[RFS_LINK])
                 + NFSclD(reqs[RFS_SYMLINK])
                 + NFSclD(reqs[RFS_MKDIR])
                 + NFSclD(reqs[RFS_RMDIR])
                 + NFSclD(reqs[RFS_READDIR])
                 + NFSclD(reqs[RFS_STATFS])
                 + NFSclD(reqs[RFS_NPROC]);

    server_other = NFSsvD(reqs[RFS_NULL])
                 + NFSsvD(reqs[RFS_SETATTR])
                 + NFSsvD(reqs[RFS_ROOT])
                 + NFSsvD(reqs[RFS_READLINK])
                 + NFSsvD(reqs[RFS_WRITECACHE])
                 + NFSsvD(reqs[RFS_CREATE])
                 + NFSsvD(reqs[RFS_REMOVE])
                 + NFSsvD(reqs[RFS_RENAME])
                 + NFSsvD(reqs[RFS_LINK])
                 + NFSsvD(reqs[RFS_SYMLINK])
                 + NFSsvD(reqs[RFS_MKDIR])
                 + NFSsvD(reqs[RFS_RMDIR])
                 + NFSsvD(reqs[RFS_READDIR])
                 + NFSsvD(reqs[RFS_STATFS])
                 + NFSsvD(reqs[RFS_NPROC]);
    move(y + 7, x); printw("%6.1f %6.1f", client_other / refresh_time,
                                          server_other / refresh_time);

    return;

} /* print_nfsstat */



void
log_nfsstat_header()
{

    /* Nothing yet */

    return;

} /* log_nfsstat_header */



void
calc_nfsstat(double refresh_time, t_nfs_stats *nfs1, t_nfs_stats *nfs2)
{

    /* Nothing yet */

    return;

} /* calc_nfsstat */



void
log_nfsstat(double refresh_time, t_nfs_stats *nfs1, t_nfs_stats *nfs2)
{

    /* Nothing yet */

    fflush(logfp);

    return;

} /* log_nfsstat */



void
log_nfsstat_max()
{

    /* Nothing yet */

    fflush(logfp);

    return;

} /* log_nfsstat_max */



void
max_nfsstat_init()
{

    /* Nothing yet */

    return;

} /* max_nfsstat_init */
