/*
 * Definitions for the CHU line discipline
 */

/*
 * The CHU time code consists of 10 BCD digits and is repeated
 * twice for a total of 10 characters.  A time is taken after
 * the arrival of each character.  The following structure is
 * used to return this stuff.
 */
#define	NCHUCHARS	(10)

struct chucode {
	u_char codechars[NCHUCHARS];	/* code characters */
	u_char ncodechars;		/* number of code characters */
	u_char chustatus;		/* not used currently */
	struct timeval codetimes[NCHUCHARS];	/* arrival times */
};
