/* -- AIX/6000 System monitor 
**
**     get_topP.h
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-1998 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

/*
 *  -- get top cpu users private include file
 */
#define swap_ptrs(cur, old, save) save = cur; cur = old; old = save

#define min(a,b) ((a) < (b) ? (a) : (b))

extern int topflag_showusername;
extern int topflag_sort;

struct procsortinfo {
     int    index;            /* index to previous procinfo-array */
     double deltacputime;
     double cputime;
     long   deltapageflt;
     long   res;              /* in core memory usage */
     long   vir;              /* virtual memory usage */
   };

extern struct procinfo     top_proc1[];
extern struct userinfo     top_user1[];
extern struct procinfo     top_proc2[];
extern struct userinfo     top_user2[];
extern struct procsortinfo top_sortinfo[];


extern int top_getprocinfo();
extern double top_calcsortinfo();
extern void get_topdata(topcpu_t *top, 
		 int ntops, 
		 struct procinfo *proc,
		 struct userinfo *user, 
		 struct procsortinfo *procsortinfo,
		 int nproc, 
		 double cpusum);

