#############################################################################
#                                                                           #
# AWK SCRIPT           M.J.E. Mol    (C) 1994, 1998                         #
#                      marcel@mesa.nl                                       #
#                                                                           #
# Date:     16apr1998                                                       #
# File:     users_day.awk                                                   #
# Version:  1.3                                                             #
#                                                                           #
# Description                                                               #
#    Take output from users_extract.awk and generate a gnuplot script that  #
#    creates postcript graphs of logged on users per interval, covering     #
#    one week. Sample records are ignored.                                  #
#                                                                           #
# Version Date      Name            Comments                                #
# ------- --------- --------------  --------------------------------------  #
#  1.0    02sep94   M.J.E. Mol      Initial version                         #
#  1.1    05sep94   M.J.E. Mol      Map daynum 0 to daynum 7                #
#                                   Reset minday/maxday after each plot     #
#  1.2    13sep94   M.J.E. Mol      Undo daynum remap, use %U on logfiles.. #
#  1.3    16apr1998 M.J.E. Mol      Renamed script. Allow comment in input. #
#                                                                           #
#############################################################################
#############################################################################
#
# Expected input:
#
#     <hostname> <weeknumber_of_year> <daynumber_of_month><monthname><year>
#         <daynumber_of_week> <interval_start_time> <interval_length>
#         <number_of_users> <max_number_of_users>
#
# Outputs:
#
#    A file specified by the 'gpf' variable containing a gnuplot program.
#    Datafiles per host and per week and used by the gnuplot program 
#    containing records of the following layout: 
#
#	<hostname> <daynumber_of_week>.<frac>
#               <number_of_users>,<max_number_of_users>
#
#    where <frac> indicates a fraction of the day, e.g. 1.5 means monday noon.
#    <...users> are the values for the interval at that part of that day.
#
#############################################################################

BEGIN {
        firsttime = 1
        minday = 100
        maxday = 0
    
    printf "set terminal postscript\n" > gpf
    printf "set time\n" >> gpf
    printf "set grid\n" >> gpf
    printf "set xlabel \"Time\"\n" >> gpf
    printf "set ylabel \"Number of Users\"\n" >> gpf
    printf "set tics out\n" >> gpf
    printf "set xrange[0:7]\n" >> gpf
    printf "set xtics 0,1,7\n" >> gpf
    printf "#set ytics 0,10,100\n" >> gpf
    printf "set data style lines\n" >> gpf

}

#
# Skip comment
#
/^#/ { next }

{
        if ($4 == 0)
            $2--
        if (host != $1 || week != $2) {
            if (firsttime)
                firsttime = 0
            else
	        dump_plot()
            datafile = dataf "." $1 "." $2
        }

	host = $1
        week = $2
        date = $3
        daynum = $4
        time = $5
        interval = $6

        if (daynum > maxday) {
            maxday = daynum
            maxdate = date
        }
        if (daynum < minday) {
            minday = daynum
            mindate = date
        }

	users[daynum, time, host] += $7
       	users_max[daynum, time, host] = $8
}

END {
    dump_plot()
}

function dump_plot () {
    system("rm -f " datafile)   
    sortcomm = "sort +1n >>" datafile

    maxy = 0
    for (combined in users) {
        split(combined, sep, SUBSEP)
        dayn = sep[1]
        time = sep[2]
	host = sep[3]
        min  = substr(time,1,2) * 60 + substr(time,4,2) 
        daypart = dayn + min / (60*24)
	printf "%s %f %f %f\n",
               host, daypart, users[combined], users_max[combined] | sortcomm
        if (users[combined] > maxy)
            maxy = users[combined]
        if (users_max[combined] > maxy)
            maxy = users_max[combined]
        delete users[combined]
        delete users_max[combined]
    }
    # Hmm, AIX needs the close
    # but gawk fails on it...
    close (sortcomm)

    maxy = int((maxy+50)/50)*50
    printf "set yrange[0:%d]\n", maxy >> gpf
    printf "set title \"Logged on users for %s in week %s - %s-%s\"\n",
           host, week, mindate, maxdate >> gpf

    printf "plot '%s' using 2:4 title \"Max Users\",\\\n", datafile >> gpf
    printf "     '%s' using 2:3 title \"Users\"\n", datafile >> gpf

    printf "#pause -1 \"bye\"\n" >> gpf

    minday = 100
    maxday = 0
}
