/* -- AIX/6000 System monitor 
**
**     get_dkstat.c
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-1998 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <stdlib.h>
#include <stdio.h>	/* for perror */
#include <string.h>	/* for memset */
#include <nlist.h>
#include "get_dkstat.h"
#include "getkmemdata.h"

/* 
 * Calculate disk summary over active disk (define) or 
 * over all disks (undefine)
 */
#undef PER_ACTIVE_DISK

struct nlist diskaddr[] = {
    {"iostat",  0, 0, 0, 0, 0},
    {NULL,      0, 0, 0, 0, 0},
};

int dk_cnt;            /* number of disks in system  */
caddr_t iostat_addr = 0;

/***************************************************************************
 *                      DATA CAPTURE FUNCTIONS                             *
 ***************************************************************************/

/*
 * get the dkstat list from kernel. This subroutine will allocate 
 * required memory if list is too short or empty 
 * Usage:
 *        include "get_dkstat.h"
 *
 *        struct dkstat *dkstat;
 *        extern int dk_cnt;
 *
 *        get_dkstat(&dkstat);
 *
 * Return: number of output lines needed...
 */

int
get_dkstat(struct dkstat **dk)
{
    struct iostat iostat;
    int i;

    if (!iostat_addr) {
        if (knlist(diskaddr, 1, sizeof(struct nlist)) == -1)
	    perror("diskaddr: entry not found");
        else
            iostat_addr = (caddr_t) diskaddr[0].n_value;
    }

    getkmemdata((char *) &iostat, sizeof(struct iostat), iostat_addr);
    dk_cnt = iostat.dk_cnt;

    for (i = 0; i < dk_cnt; i++) {
        if (!dk[i]) 
	    dk[i] = (struct dkstat *) malloc(sizeof(struct dkstat));
        getkmemdata((char *) dk[i], sizeof(struct dkstat),
                    i==0 ? (caddr_t) iostat.dkstatp :
                           (caddr_t) dk[i-1]->dknextp);
    }

    return dk_cnt+1; /* add 1 for the 'Active disks' line */

} /* get_dkstat */



int
summarize_dkstat(struct dkstat *sump,
                     struct dkstat *dk1[], struct dkstat *dk2[])
{
    int i, active = 0;

    memset(sump, 0, sizeof(struct dkstat));
    for (i = 0; i < dk_cnt; i++) {
        sump->dk_bsize += dk1[i]->dk_bsize;
        sump->dk_xrate += dk1[i]->dk_xrate;
        sump->dk_rblks += dk1[i]->dk_rblks - dk2[i]->dk_rblks;
        sump->dk_wblks += dk1[i]->dk_wblks - dk2[i]->dk_wblks;
        sump->dk_xfers += dk1[i]->dk_xfers - dk2[i]->dk_xfers;
        sump->dk_seek  += dk1[i]->dk_seek  - dk2[i]->dk_seek;
        sump->dk_time  += dk1[i]->dk_time  - dk2[i]->dk_time;
        if (dk1[i]->dk_xfers - dk2[i]->dk_xfers)
            active++;
    }

#if defined(PER_ACTIVE_DISK)
    if (active) {
        sump->dk_bsize /= active;
        sump->dk_xrate /= active;
    }
#else
    if (dk_cnt) {
        sump->dk_bsize /= dk_cnt;
        sump->dk_xrate /= dk_cnt;
    }
#endif

    return active;

} /* summarize_dkstat */
