#define		MAINLINE
#include	"parms.h"
#include	"structs.h"

#ifdef	RCSIDENT
static char rcsid[] = "$Header: /home/ace/master/rmtc/misc/notes/src/Misc/newmain.c,v 1.1 1989/05/15 11:16:26 polk Exp $";
#endif	RCSIDENT

/*
 *	this  main program will take in a notefile name, and
 *	then proceed to handle all of the processing for it. This includes
 *	calling all of the appropriate routines. It should stay in the 
 *	package pretty much as is. It may not be the master routine, but
 *	it will be the chief 'driver' while within a particular note.
 *
 *	Original author: Rob Kolstad	Winter, 1980.
 *	Modifications:	Ray Essick	June, 1981.
 *	Modified more:	Ray Essick	May, 1982.
 *
 *	This program is code-sharable. 
 */

#include "globs.h"					/* everything that belongs in a mainline */

char   *getenv ();					/* returns environment variables */


main (argc, argv)
int     argc;
char  **argv;
{

    int     i,
            j,
            k;
    int     c;						/* hold chars from getc */
    char   *p,
           *q,
           *command,
            nfname[NNLEN],
            cmdline[CMDLEN];				/* build-a-command */
    FILE * flist;					/* so can use -f option */
    int     autoseq;

#include "main.i"					/* common init code and such */

    if (globuid == Anonuid)
    {
	printf ("Sorry, you have the wrong uid (%d) to use notesfiles.\n",
		globuid);
	printf ("Consult your local system guru for more help\n");
	exit (BAD);
    }

    autoseq = 0;					/* default not autoseq */

    if ((q = rindex (argv[0], '/')) != 0)		/* get invoking name */
	q++;
    else
	q = argv[0];					/* no slash */

    if (strcmp (q, AUTOSEQ))				/* is it autoseq? */
	autoseq++;

    if (argc == 1 && autoseq == 0)
    {
	printf ("Usage: %s [-s] [-t ttytype] [-f file] topic [...]\n", argv[0]);
	printf ("Hit <return> to continue\n");		/* let him ponder this */
	getc (stdin);					/* courtesy of harpo!ber 4/30/82 */
	if ((command = getenv ("PAGER")) == NULL)	/* overridden? */
	    command = PAGER;				/* assign default */
#ifndef	FASTFORK
	sprintf (cmdline, "%s < %s/%s/%s", command, Mstdir, UTILITY, AVAILHLP);
	dounix (cmdline, 1, 0);				/* print the list */
#else
	sprintf (cmdline, "%s/%s/%s", Mstdir, UTILITY, AVAILHLP);
	dounix (1, 0, command, cmdline, 0, 0, 0);
#endif
	exit (BAD);
    }

    if ((p = getenv ("SHELL")) != 0)			/* get favorite shell */
	strmove (p, hisshell);
    if ((p = getenv ("NFED")) != 0)			/* and favorite editor */
	strmove (p, hised);
    else
	if ((p = getenv ("EDITOR")) != 0)		/* used by others */
	    strmove (p, hised);


/*
 *	Parse the command line. This includes picking out the options,
 *	and the list of notesfiles to read/not-read along with
 *	the sequencing modes desired.
 */
    for (i = 0; i < argc; i++)
    {

	if (argv[i][0] == '-')
	{
/*
 *	handle options processing 
 */
	    switch (argp[1])
	    {
		case 't': 				/* set up tty type */
		    if (++i == argc)
		    {
			fprintf (stderr,
				" option -t must be followed by terminal type\n");
			exit (BAD);
		    }
		    histty = argv[i];
		    break;

		case 's': 				/* sequencer flavors */
		case 'n': 
		case 'x': 
		case 'i': 
		    expand (argp);			/* handle it down there */
		    break;

		case 'f': 				/* args from a file */
		    if (++i == argc)			/* see if there is one */
		    {
			fprintf (stderr,
				"Option -f must be followed by a file name\n");
			exit (BAD);
		    }
		    readrc (argv[++i]);			/* handle it */
		    break;

		default: 
		    printf ("Bad switch `%c'\n", argv[i][1]);
		    ttystop ();
		    exit (BAD);

	    }
	}
	else						/* just expand it */
	    expand (argv[i]);
    }

/* 
 * Arguments all processed.  Read the notesfiles.
 */
    ttystrt ();						/* CBREAK mode */
    for (i = 0; i < last_group; i++)
    {
	if (group[i].lookat == FALSE)			/* changed his mind */
	    continue;
	switch (control (group[i].name, group[i].seqtyp))
	{
	    case QUITFAST: 
	    case QUITUPD: 
		cleanup (GOOD);
		break;
	    case QUITNEX: 
		printf ("No such notesfile `%s'\n", group[i].name);
		break;
	    case -1: 
		prompt ("%s...", group[i].name);
		fflush (stdout);
		break;
	    case QUITBAD: 
	    default: 
		break;
	}
    }
}
cleanup (status)
{
    at (0, 1);						/* place him at the bottom of the screen */
    putc ('\n', stdout);
    ttystop ();						/* back to normal mode */
    exit (status);
}
